<?php
abstract class ExpanderBase extends BaseFactory 
{
	public function toGetExpInfo()
	{
		$handler = new ExpInfoXmlHandler();
		$this->runCommand(XMLAPICommand::MV_PD_GetExpanderInfo, $handler);
	}

    public function toGetEnclosureInfo()
    {
        foreach ($this->BaseClasses as $exp)
        {
            if ($exp->getEnclosureID() != UNDEFINED_ID)
            {
                $enc = new EnclDetail();
                $enc->setAdapterID($this->getAdapterID());
                $enc->setEnclID($exp->getEnclosureID());
                $enc->toGetEnclInfo();
                $enc->toGetEnclElementInfo();
                $enc->toGetEnclElementCfg();
                $encDtl = $enc->getBaseDetail();
                if ($encDtl) {
                    $exp->setEnclosure($encDtl);
                }
            }
        }
    }
	
	protected function createObject()
	{
		return new ExpanderDevice();
	}
}
?>