<?php
class SSD extends SASDevice {
	private $NANDType;
	private $Size;
	private $Status;
	private $SerialNo;
	private $FWVersion;
	private $remainingDiskLife;
	private $opLevel;
	private $safeMode;
	private $AdapterID;

	public function getNANDType(){
		return $this->NANDType;
	}
	
	public function getSize(){
		return $this->Size;
	}
	
	public function getStatus(){
		return $this->Status;
	}
	
	public function getSerialNo(){
		return $this->SerialNo;
	}
	
	public function getFWVersion(){
		return $this->FWVersion;
	}
	
	public function getRemainingDiskLife(){
		return $this->remainingDiskLife;
	}
	
	public function getOpLevel(){
		return $this->opLevel;
	}
	
	public function getSafeMode(){
		return $this->safeMode;
	}
	
	public function getAdapterID(){
		return $this->AdapterID;
	}
	
	public function isAssigned()
	{
		return $this->Status & HdStatus::HD_STATUS_ASSIGNED;
	}
	
	public function isSAS()
	{
		return 0;
	}
	
	public function setSSDInfo($Info){
		
 		if (isset($Info->AdapterID)) {
 			$this->AdapterID = trim($Info->AdapterID);
 		}
 		
		if (isset($Info->ID)) {
			$this->setDeviceID(intval(trim($Info->ID)));
		}
		
		if (isset($Info->NANDType)) {
			$this->NANDType = $Info->NANDType;
		}
		
		if (isset($Info->Size)) {
			$this->Size = $Info->Size;
		}
		
		if (isset($Info->Status)) {
			$this->Status = $Info->Status;
		}
		
		if (isset($Info->SerialNo)) {
			$this->SerialNo = $Info->SerialNo;
		}
		
		if (isset($Info->FWVersion)) {
			$this->FWVersion = $Info->FWVersion;
		}
		
		if (isset($Info->remainingDiskLife)) {
			$this->remainingDiskLife = $Info->remainingDiskLife;
		}
		
		if (isset($Info->opLevel)) {
			$this->opLevel = $Info->opLevel;
		}
		
		if (isset($Info->safeMode)) {
			$this->safeMode  = $Info->safeMode;
		}
	}
}
?>