<?php

class BGAJob
{
	private $index;
	private $VDID;
	private $HDIDs;
	private $bgaType;
	private $cmdPara;
	private $settingType;
	private $settingTime;
	private $settingDate;
	private $settingDateSupplement;
	private $startTime;
	private $status;
	private $result;
	private $resultText;

	public function getIndex()
	{
		return $this->index;
	}
	public function setIndex($index)
	{
		$this->index = $index;
	}
	
	public function setVDID($VDID)
	{
		$this->VDID = $VDID;
	}
	public function getVDID()
	{
		return $this->VDID;
	}
	
	public function setHDID($HDIDs)
	{
		$this->HDIDs = $HDIDs;
	}
	public function getHDID()
	{
		return $this->HDIDs;
	}
	
	public function setBgaType($bgaType)
	{
		$this->bgaType = $bgaType;
	}
	public function getBgaType()
	{
		return $this->bgaType;
	}
	
	public function setStartTime($startTime)
	{
		$this->startTime = $startTime;
	}
	public function getStartTime()
	{
		return $this->startTime;
	}
	
	public function setCmdPara($cmdPara)
	{
		$this->cmdPara = $cmdPara;
	}
	public function getCmdPara()
	{
		return $this->cmdPara;
	}
	
	public function setSettingType($settingType)
	{
		$this->settingType = $settingType;
	}
	
	public function getSettingType()
	{
		return $this->settingType;
	}
	
	public function isNoRepeat()
	{
		return $this->settingType == ScheduleSettingType::No_REPEAT;
	}
	
	public function isDayRepeat()
	{
		return $this->settingType == ScheduleSettingType::DAY_REPEAT;
	}
	
	public function isMonthRepeat()
	{
		return $this->settingType == ScheduleSettingType::MONTH_REPEAT;
	}
	
	public function isWeekRepeat()
	{
		return $this->settingType == ScheduleSettingType::WEEK_REPEAT;
	}
	
	public function setSettingTime($settingTime)
	{
		$this->settingTime = $settingTime;
	}
	
	public function getSettingTime()
	{
		return $this->settingTime;
	}
	
	public function setSettingDate($settingDate)
	{
		$this->settingDate = $settingDate;
	}
	
	public function getSettingDate()
	{
		return $this->settingDate;
	}
	
	public function setSettingDateSupplement($settingDateSupplement)
	{
		$this->settingDateSupplement = $settingDateSupplement;
	}
	
	public function getSettingDateSupplement()
	{
		return $this->settingDateSupplement;
	}
	
	public function setStatus($status)
	{
		$this->status = $status;
	}
	public function getStatus()
	{
		return $this->status;
	}
	public function isRun()
	{
		return $this->status == ScheduleStatus::RUN;
	}
	
	public function isNotRun()
	{
		return $this->status == ScheduleStatus::NOT_RUN ;
	}
	
	public function isReading()
	{
		return $this->status == ScheduleStatus::READING ;
	}
	
	public function setResult($result)
	{
		$this->result = $result;
	}
	public function getResult()
	{
		return $this->result;
	}
	
	public function setResultText($resultText)
	{
		$this->resultText = $resultText;
	}
	public function getResultText()
	{
		return $this->resultText;
	}
	
	//set data from XML element
	public function setInfoFromXML($element)
	{
		$this->VDID = trim($element->VDID);
		$this->index = trim($element->index);
		$this->bgaType = trim($element->bgaType);
		$this->cmdPara = trim($element->cmdPara);
		$this->settingType = trim($element->settingType);
		$this->settingTime = trim($element->settingTime);
		$this->settingDate = (trim($element->settingDate));
		$this->settingDateSupplement = (trim($element->settingDateSupplement));
		$this->startTime = (trim($element->startTime));
		$this->status = (trim($element->status));
		$this->result = (trim($element->result));
		$this->resultText = (trim($element->resultText));
	}
	
	//create instance from xml element
	public static function createBGAJobFromXMLElement($element)
	{
		$job = new BGAJob();
		$job->setInfoFromXML($element);
		return $job;
	}
}

?>