<?php
class PgSubPlatoFWFlashDisplayer extends PageDisplayer {

    protected function initPage() {
        //$filepath = "../db/" . getRequestPara("FilePath");

        $this->setPageName("XML_PlatoFWFlash.tpl");
        $smarty = $this->smarty;

        //do upload
	$filepath = getRequestPara("filePath");

        $currentBinVersion = "0.0.0.0";   //get from hba info

        $container = new CtnSSDAdapterDetail();
        $container->setID($this->getAdapterID());
        $container->toGetSSDAdapterInfo();
        $container->smartyAssign($smarty);
        $container->initContainer();

        $ssdAdapterInfo = $container->getBase()->getBaseDetail();
        $currentBinVersion = $ssdAdapterInfo->getFirmwareVersion();

        $smarty->assign("currentBinVersion", $currentBinVersion);

        $newTmpDir = "..\\tmp";
        if (getRequestPara("uploadFile") || getRequestPara("uploadFlash")) {
            if (!isset($filepath) || $filePath == "") {
                if (isset($_FILES['boisFile']) && $_FILES['boisFile']["name"] != "") {
                    $tmpfilepath = $_FILES["boisFile"]["tmp_name"];
                    $name = $_FILES["boisFile"]["name"];
                    $size = $_FILES["boisFile"]["size"];

                    if (!is_dir($newTmpDir)) {
                        mkdir($newTmpDir);
                    }

                    $filepath = $newTmpDir . "\\Image";
                    move_uploaded_file($tmpfilepath, $filepath);

    //                if ($size > $fileMaxSize) {
    //                    $smarty->assign("fileMaxSize", $fileMaxSize/1024);
    //                    $smarty->assign("flashResult", FlashResult::FLASH_FILETOOLARGE);
    //                    return;
    //                }
                }
            }
            //get bin file version
            $binVersion = "";
            $VenID = "";
            $DevID = "";

            $apiCmd = new XMLAPICommand();
            $apiCmd->setCommand(XMLAPICommand::MV_SSD_GetFWImgVersion);
            $apiCmd->setCommandPara('filepath', $filepath);
            $apiCmd->setCommandPara('AdapterID', $this->getAdapterID());
            $apiCmd->issueCommand();

            $xmlData = $apiCmd->getResult();
            if (isset ($xmlData) && $xmlData->RetVal . "" == 0) { //if successfully
                //check version
                $VerMajor = 0;
                $VerMinor = 0;
                $VerOEM = 0;
                $VerBuild = 0;

                if (isset($xmlData->Firmware_Version)) {
                    foreach ($xmlData->Firmware_Version as $bsVersion) {
                        foreach ($bsVersion->VerMajor as $version) {
                            $VerMajor = trim($version);
                        }
                        foreach ($bsVersion->VerMinor as $version) {
                            $VerMinor = trim($version);
                        }
                        foreach ($bsVersion->VerOEM as $version) {
                            $VerOEM = trim($version);
                        }
                        foreach ($bsVersion->VerBuild as $version) {
                            $VerBuild = trim($version);
                        }
                    }

                }
                if ($VerMajor || $VerMinor || $VerOEM || $VerBuild) {
                    $binVersion = $VerMajor . "." . $VerMinor . "." . $VerOEM . "." . $VerBuild;
                    $smarty->assign("binVersion", $binVersion);
                    $smarty->assign("HBAID", $this->getAdapterID());
                }

            } else {  //get  version failed
                $flashResult = FlashResult::FLASH_GETVERSIONFAILED;
                $smarty->assign("flashResult", FlashResult::FLASH_GETVERSIONFAILED );
            }
            $smarty->assign("filePath", $filepath);


            $flashSuccess = 0;
            //flash firmware
            if (file_exists($filepath) && getRequestPara("uploadFlash")) {
		if (getRequestPara("force") == null && ($binVersion <= $currentBinVersion)) {
                    //check versions
                     //old version
                        $smarty->assign("needForceConfirm", 1);

                } else {

                    $apiCmd = new XMLAPICommand();
                    $apiCmd->setCommand(XMLAPICommand::MV_SSD_Download_Firmware);
                    $apiCmd->setCommandPara('AdapterID', $this->getAdapterID());
                    $apiCmd->setCommandPara('filepath', $filepath);
                    if (($binVersion > $currentBinVersion))
                        $apiCmd->setCommandPara('force', 0);
                    else
                        $apiCmd->setCommandPara('force', 1);

                    $apiCmd->issueCommand();

                    if ($apiCmd->getResult()->RetVal . "" == 0) {
                        $flashSuccess = FlashResult::FLASH_SUCCESS ;
                    }
                    else {
                        $flashSuccess = FlashResult::FLASH_UPLOADFAILED ;
                    }

                    $flashResult = $flashSuccess;
                    $smarty->assign("flashResult", $flashSuccess);

                }
                //always remove the file after operations
                if (file_exists($filepath) && trim($filepath) !== "") {
                    unlink($filepath);
                    rmdir($newTmpDir);
                }
            }


            $smarty->assign("filePath", $filepath);
            $smarty->assign("HBAID", $this->getAdapterID());
            $smarty->assign("result", 1);
        }
    }
}

?>
