<?php
class PackageVDInfo extends LDInfo
{
    public $DGID = 0;
    public $TotalManagedSpace = 0;
    public $RemainingManagedSpace = 0;
    public $SmallestAvailablePDSize = 0;
    public $PDCount = 0;
    public $PDIDs = 0;
    public $SparePDCount = 0;
    public $SparePDIDs = 0;
    public $BlockSize = 0;
    public $BgaType = 0;
    public $WriteCacheOn = 0;
	public $spareHDIDs = array();
	public $spareHDList = array();
	public $HDList = array();
	public $NumParityDisk;
    
	public function setLdInfo($LD)
	{
        parent::setLDInfo($LD);

        $this->DGID = $LD->getDGID();
        $this->TotalManagedSpace = $LD->getTotalManagedSpace();
        $this->RemainingManagedSpace = $LD->getRemainingManagedSpace();
        $this->SmallestAvailablePDSize = $LD->getSmallestAvailablePDSize();
        $this->PDCount = $LD->getPDCount();
        $this->PDIDs = $LD->getPDIDs();
        $this->SparePDCount = $LD->getSparePDCount();
        $this->SparePDIDs = $LD->getSparePDIDs();
        $this->BlockSize = $LD->getBlockSize();
        $this->BgaType = $LD->getBgaType();
		$this->NumParityDisk = $LD->getNumParityDisk();

	    //set HD info
		foreach ($LD->getHDList() as $hd) {
			$hdInfo = new HDInfo();
			$hdInfo->setHDInfo($hd);
			$hdInfo->setConnectInfo($hd);
			$this->HDList[] = $hdInfo;
		}
		//set spare HD info
		foreach ($LD->getSpareHDList() as $hd)
		{
			$hdInfo = new HDInfo();
			$hdInfo->setHDInfo($hd);
			$hdInfo->setConnectInfo($hd);
			$this->spareHDList[] = $hdInfo;
		}
	}
	
	public function setLDDtl($LD)
	{
        parent::setLDDtl($LD);
        $this->WriteCacheOn = $LD->getWriteCacheOn();
	}
	
//	private function setBGAStrings()
//	{
//		$TmpStr = LDStatus::getLDStatusStr($this->StatusInt);
//		$this->StatusString = gettext($TmpStr);
//
//		$TmpStr = LdBgaStatus::getLdBgaString($this->Bga);
//		$this->BgaString = gettext($TmpStr);
//
//		$TmpStr = LdBgaStatus::getLdBgaStatusStr($this->Bga);
//		$this->BgaStatusString = gettext($TmpStr);
//
//		if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_RUNNING ||
//			$this->BgaStateInt == LdBgaState::LD_BGA_STATE_NONE )
//		{
//			$this->BgaStateString = "";
//		}
//		else {
//			$TmpStr = LdBgaState::getLdBgaStateStr($this->BgaStateInt);
//			$this->BgaStateString = gettext($TmpStr);
//		}
//	}
	
}

?>