﻿using Intel.Cst.Client;
using log4net;
using System;
using System.Configuration;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Windows.Forms;

namespace SampleApp
{
    internal static class SampleAppProgram
    {
        public static FormWALWOA walwoaForm;
        private static Logger logger;

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        private static void Main(string[] args)
        {
            // On .NET Core/5 apps, the following line would be XmlConfigurator.Configure(LogManager.GetRepository(), new FileInfo("log4net.config"))
            // or similar to load the config file before calling the Logger methods to perform the runtime configuration.
            // Since this is a .NET framework app and it loads the config file with an assembly-level call (see AssemblyInfo.cs),
            // we just need to make sure that this assembly is the first thing to call into log4net so it loads the config file properly.
            LogManager.GetLogger(typeof(SampleAppProgram));

            logger = new Logger();
            logger.ConfigLoggingLevel();

            string logFile = ConfigurationManager.AppSettings["logFile"];
            string localAppFolder = Application.LocalUserAppDataPath;
            string logPath = Path.Combine(localAppFolder, "Logs");
            Directory.CreateDirectory(logPath);
            logger.Debug("path" + localAppFolder);
            logFile = Path.Combine(logPath, logFile);

            logger.SetAppLog(logFile);

            Process currentProcess = Process.GetCurrentProcess();
            string sampleAppProcess = currentProcess.ProcessName;
            int currentSessionId = currentProcess.SessionId;
            int currentProcessId = currentProcess.Id;
            if (Process.GetProcesses().Count(p => (p.ProcessName == sampleAppProcess && p.SessionId == currentSessionId && p.Id != currentProcessId)) >= 1)
            {
                return;
            }
            else
            {
                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);

                bool bHidePrimaryGUI = false;
                if (args.Count() > 0)
                {
                    bHidePrimaryGUI = args[0].Equals("startup", StringComparison.InvariantCultureIgnoreCase);
                }

                walwoaForm = new FormWALWOA(bHidePrimaryGUI);
                Application.Run(walwoaForm);
            }
        }
    }
}