/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.utils;

import com.intel.sensing.fdk.common.ManagerEnums;
import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.common.utils.CUtils;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.model.abstractData.Category;
import com.intel.sensing.fdk.model.dao.DaoFactory;
import com.intel.sensing.fdk.model.dao.ModuleDao;
import com.intel.sensing.fdk.model.entity.FirmwareKit;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.entity.ProjectEntity;
import com.intel.sensing.fdk.model.project.ISSProject;
import com.intel.sensing.fdk.model.service.PersistenceService;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ISSProjectUtils {
    public static void validateWorkspacePath() throws ISSException {
        if (!ISSProjectUtils.isValidPath()) {
            throw new ISSException("The project's path can only contain the following characters: a-z, A-Z, 0-9, / : \\ _ - and .");
        }
    }

    public static boolean isValidPath() throws ISSException {
        IPath path = CUtils.GetWorkspaceLocation();
        if (path == null) {
            return false;
        }
        String pathS = path.toString();
        pathS = pathS.replace("\\", "");
        pathS = pathS.replace("/", "");
        pathS = pathS.replace(":", "");
        pathS = pathS.replace("-", "");
        pathS = pathS.replace(".", "");
        return pathS.matches("[a-zA-Z0-9_]*$");
    }

    public static IProject getProjectByName(String projectName) {
        IProject[] iProjects;
        IProject[] iProjectArray = iProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            if (proj.isAccessible() && proj.getName().contentEquals(projectName)) {
                return proj;
            }
            ++n2;
        }
        return null;
    }

    public static IFile getProjectFileByName(String projName, String fileName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projName).getFile(fileName);
    }

    public static void addNatureToProject(IProject project, String natureId) throws CoreException {
        String[] projectNatures;
        ISSLogger.i((String)("Adding ISS nature to project " + project.getName()));
        IProjectDescription description = project.getDescription();
        String[] stringArray = projectNatures = description.getNatureIds();
        int n = projectNatures.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (n3.equals(natureId)) {
                return;
            }
            ++n2;
        }
        String[] newProjectNatures = new String[projectNatures.length + 1];
        int i = 0;
        while (i < projectNatures.length) {
            newProjectNatures[i] = projectNatures[i];
            ++i;
        }
        newProjectNatures[newProjectNatures.length - 1] = natureId;
        description.setNatureIds(newProjectNatures);
        project.setDescription(description, null);
    }

    public static void setFilesPermissionsRecursively(File[] files) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                ISSProjectUtils.setFilesPermissionsRecursively(file.listFiles());
                ISSProjectUtils.setFilePermissions(file);
            } else {
                ISSProjectUtils.setFilePermissions(file);
            }
            ++n2;
        }
    }

    private static void setFilePermissions(File file) {
        file.setWritable(true);
    }

    public static void setProjectPermission(IProject project) {
        File folder = new File(project.getProject().getLocation().toString());
        ISSProjectUtils.setFilesPermissionsRecursively(folder.listFiles());
    }

    public static void closeProjectOpenFiles(IProject project) {
    }

    public static boolean valideProject(IProject proj) throws ISSException {
        if (proj.findMember("project.json") == null) {
            throw new ISSException("can't find project josn file");
        }
        if (proj.findMember("selected_sensors.json") == null) {
            throw new ISSException("can't find select sensor file");
        }
        return true;
    }

    public static String validateModule(ModuleEntity me) {
        String sensorJsonFile;
        String jsonFile = me.getJsonFilePath();
        if (!new File(jsonFile).exists()) {
            return "Module json file isn't existed.";
        }
        if (me.getCategoryInData().equals(Category.SENSOR) && !new File(sensorJsonFile = me.getSensorBundle().getJsonFilePath()).exists()) {
            return "Sensor json file isn't existed.";
        }
        return null;
    }

    public static boolean isAccessableISSProject(IProject proj) {
        if (!proj.isAccessible()) {
            return false;
        }
        IProjectNature issNature = null;
        try {
            issNature = proj.getNature("com.intel.sensing.lpsensingprojectnature");
        }
        catch (Exception e) {
            ISSLogger.e((Exception)e);
            return false;
        }
        return issNature != null;
    }

    public static List<ModuleEntity> getUserModulesForExternal(String projectPath) {
        ArrayList<ModuleEntity> ret = new ArrayList<ModuleEntity>();
        String modulePath = String.valueOf(projectPath) + File.separator + "modules";
        Path path = Path.of(modulePath, new String[0]);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Stream<Path> paths = Files.walk(path, 2, new FileVisitOption[0]);){
                List moduleStrList = paths.filter(file -> file.toFile().exists() && file.toFile().isDirectory() && file.resolve("module.json").toFile().exists()).map(file -> file.resolve("module.json").toAbsolutePath().toString()).collect(Collectors.toList());
                ModuleDao _moduleDao = DaoFactory.getDao(ModuleDao.class);
                for (String jsonPath : moduleStrList) {
                    ModuleEntity entity = _moduleDao.getEntityByFilePath(jsonPath);
                    if (entity == null) continue;
                    ret.add(entity);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ISSLogger.e((Exception)e);
        }
        return ret;
    }

    public static String getSelectJsonFilePath(IPath projectPath) {
        return String.valueOf(projectPath.toOSString()) + File.separator + "selected_sensors.json";
    }

    public static String getSelectJsonFilePath(IProject project) {
        return ISSProjectUtils.getSelectJsonFilePath(project.getFullPath());
    }

    public static String getSelectJsonFilePath(String projectName) {
        IPath path = CUtils.GetWorkspaceLocation().append(projectName);
        return ISSProjectUtils.getSelectJsonFilePath(path);
    }

    public static String getBinFolder(ISSProject proj) {
        return String.valueOf(proj.getProjectPath()) + "\\bin";
    }

    public static String getPdtsFolder(ISSProject project) {
        return String.valueOf(project.getProjectPath()) + "\\PDTs";
    }

    public static String getISSBinFile(ISSProject project, String compileMode) {
        return String.valueOf(project.getProjectPath()) + File.separator + "out" + File.separator + compileMode + File.separator + "ish_SI.bin";
    }

    public static String getPdtsFolder(String projectPath, String platform) {
        return String.valueOf(projectPath) + "\\PDTs\\" + platform;
    }

    public static String getPdtsBinaryPath(String projectPath, String platform) {
        return String.valueOf(projectPath) + "\\PDTs\\" + platform + File.separator + platform + "_PDT.bin";
    }

    public static String getPdtsNVARBinaryPath(String projectPath, String platform) {
        return String.valueOf(projectPath) + "\\PDTs\\" + platform + File.separator + platform + "_PDT_NVAR.bin";
    }

    public static String getPdtsBinaryPath(ISSProject project) {
        String plat = project.getPlatform();
        return String.valueOf(ISSProjectUtils.getPdtsFolder(project)) + File.separator + plat + File.separator + plat + "_PDT.bin";
    }

    public static String getPdtsNVARBinaryPath(ISSProject project) {
        String plat = project.getPlatform();
        return String.valueOf(ISSProjectUtils.getPdtsFolder(project)) + File.separator + plat + File.separator + plat + "_PDT_NVAR.bin";
    }

    public static String getUserTempPdtFolder() throws Exception {
        return String.valueOf(ManagerFileUtils.getUserEclipsePluginFolder()) + "\\TEMP_PDT";
    }

    public static String getProjectJsonFilePath(IPath projPath) {
        return String.valueOf(projPath.toOSString()) + File.separator + "project.json";
    }

    public static String getProjectJsonFilePath(String projectName) {
        IPath path = CUtils.GetWorkspaceLocation().append(projectName);
        return ISSProjectUtils.getProjectJsonFilePath(path);
    }

    public static String getProjectJsonFilePath(IProject project) {
        return ISSProjectUtils.getProjectJsonFilePath(project.getFullPath());
    }

    public static String getSelectedJsonFileByProjectPath(String projectPath) {
        return String.valueOf(projectPath) + File.separator + "selected_sensors.json";
    }

    public static String getProjectJsonFileByProjectPath(String projectPath) {
        return String.valueOf(projectPath) + File.separator + "project.json";
    }

    public static String getOutputFolder(ISSProject project) {
        return String.valueOf(project.getProjectPath()) + File.separator + "out";
    }

    public static String getReleaseOutputFolder(ISSProject project) {
        return String.valueOf(ISSProjectUtils.getOutputFolder(project)) + File.separator + ManagerEnums.CompilationMode.Release.getFriendlyName();
    }

    public static boolean isProjectConfigureFile(IFile file) {
        if (file == null) {
            return false;
        }
        if (file.getProject().getFile("project.json").equals((Object)file)) {
            return true;
        }
        return file.getProject().getFile("selected_sensors.json").equals((Object)file);
    }

    public static boolean isModuleConfigureFile(IFile file) {
        if (file == null) {
            return false;
        }
        String name = file.getName();
        return name.toLowerCase().equals("module.json") || name.toLowerCase().equals("sensor.json");
    }

    public static void addIncludePaths(IProject project, ICProjectDescription des, ProjectEntity pe) throws Exception {
        ICConfigurationDescription[] configDescriptions;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configDescriptions = des.getConfigurations();
        int n = configDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting[] settings;
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            ICFolderDescription rootDescription = configDescription.getRootFolderDescription();
            ICLanguageSetting[] iCLanguageSettingArray = settings = rootDescription.getLanguageSettings();
            int n3 = settings.length;
            int n4 = 0;
            while (n4 < n3) {
                List<String> includeFolders;
                ICLanguageSetting setting = iCLanguageSettingArray[n4];
                ArrayList<ICLanguageSettingEntry> includes = new ArrayList<ICLanguageSettingEntry>();
                FirmwareKit kit = PersistenceService.getFwKitByPlatformAndVersion(pe.getPlatform(), pe.getFwVersionInData());
                if (kit != null && (includeFolders = kit.getProjectDefaultIncludes()) != null) {
                    for (String includeFolder : includeFolders) {
                        ISSProjectUtils.recursiveAddTheIncludeFolders(includeFolder, includes);
                    }
                    setting.setSettingEntries(1, includes);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void recursiveAddTheIncludeFolders(String currentPath, List<ICLanguageSettingEntry> includes) {
        File currentFile = new File(currentPath);
        if (currentFile.isDirectory()) {
            includes.add((ICLanguageSettingEntry)new CIncludePathEntry(currentPath, 20));
            String[] stringArray = currentFile.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                ISSProjectUtils.recursiveAddTheIncludeFolders(String.valueOf(currentPath) + "\\" + file, includes);
                ++n2;
            }
        }
    }

    public static void updateIncludePath(IProject project, ProjectEntity projectEntity) throws Exception {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(project, true);
        ISSProjectUtils.addIncludePaths(project, des, projectEntity);
        mngr.setProjectDescription(project, des);
        ICProject icproject = CCorePlugin.getDefault().getCoreModel().getCModel().getCProject(project.getName());
        CCorePlugin.getIndexManager().reindex(icproject);
    }
}

