/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.dao;

import com.intel.sensing.fdk.common.ManagerEnums;
import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.model.abstractData.Version;
import com.intel.sensing.fdk.model.dao.AbstractJsonDao;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.entity.ProjectEntity;
import com.intel.sensing.fdk.model.entity.SelectedItemsDataEntity;
import com.intel.sensing.fdk.model.entity.SelectedSensorsEntity;
import com.intel.sensing.fdk.model.entity.SensorDataEntity;
import com.intel.sensing.fdk.model.service.PersistenceService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SelectedSensorsDao
extends AbstractJsonDao<SelectedSensorsEntity> {
    @Override
    public SelectedSensorsEntity getEntityByFilePath(String filePath) throws ISSException {
        SelectedSensorsEntity entity = (SelectedSensorsEntity)this.getEntityByFilePath(filePath, SelectedSensorsEntity.class);
        return entity;
    }

    public SelectedSensorsEntity getEntityByFilePath(String filePath, ProjectEntity projectEntity, List<ModuleEntity> userModules) throws ISSException {
        SelectedSensorsEntity entity = this.getEntityByFilePath(filePath);
        if (entity == null) {
            return entity;
        }
        List<String> sensorTable = entity.getSensortable();
        List<SelectedItemsDataEntity> sensorDataList = sensorTable.parallelStream().flatMap(sensorStr -> this.parseSensorTable(projectEntity, userModules, (String)sensorStr).stream()).filter(p -> p != null).collect(Collectors.toList());
        entity.setSelectItems(sensorDataList);
        return entity;
    }

    public SelectedSensorsEntity getEntityByFilePathUnBlocked(String filePath, ProjectEntity pe, List<ModuleEntity> userModules) throws ISSException {
        SelectedSensorsEntity entity = this.getEntityByFilePath(filePath, pe, userModules);
        if (entity != null) {
            return entity;
        }
        return new SelectedSensorsEntity();
    }

    private List<SelectedItemsDataEntity> parseSensorTable(ProjectEntity projectEntity, List<ModuleEntity> userModules, String sensorStr) {
        String moduleStr = "";
        String selectedStr = "";
        String platform = projectEntity.getPlatform();
        String fwVersion = projectEntity.getFwVersion();
        ArrayList<SelectedItemsDataEntity> selectedSensorList = new ArrayList<SelectedItemsDataEntity>();
        try {
            if (sensorStr.contains("@SELECTED")) {
                moduleStr = sensorStr.split("@SELECTED")[0];
                selectedStr = sensorStr.split("@SELECTED")[1];
            } else {
                moduleStr = sensorStr;
            }
            String relativePath = moduleStr.split(" ")[0];
            String tag = moduleStr.split(" ")[1];
            switch (ManagerEnums.ISSModuleTags.getByTag((String)tag)) {
                case USER: {
                    List<SensorDataEntity> userModuleList = userModules.stream().filter(mdoule -> mdoule.isSensor()).flatMap(Module -> Module.getSensorBundle().getSensors().stream()).collect(Collectors.toList());
                    this.filterSensor(selectedStr, selectedSensorList, relativePath, userModuleList, false);
                    List<ModuleEntity> userLibraryList = userModules.stream().filter(module -> module.isLibrary()).collect(Collectors.toList());
                    this.filterLibrary(sensorStr, selectedSensorList, relativePath, userLibraryList, false);
                    break;
                }
                case KITS: {
                    List<SensorDataEntity> kitSensorList = PersistenceService.getFwKitSensorList(platform, Version.valueOf(fwVersion));
                    this.filterSensor(selectedStr, selectedSensorList, relativePath, kitSensorList, false);
                    break;
                }
                case INSTALLED: {
                    List<SensorDataEntity> installedSensorList = PersistenceService.getAllInstalledSensorList();
                    this.filterSensor(selectedStr, selectedSensorList, relativePath, installedSensorList, true);
                    List<ModuleEntity> installedLibraryList = PersistenceService.getAllInstalledLibraryList();
                    this.filterLibrary(sensorStr, selectedSensorList, relativePath, installedLibraryList, true);
                }
            }
        }
        catch (Exception e) {
            ISSLogger.e((Exception)e);
        }
        return selectedSensorList;
    }

    private void filterSensor(String selectedStr, List<SelectedItemsDataEntity> selectedSensorList, String relativePath, List<SensorDataEntity> lookupSensorList, boolean isInstall) {
        String moduleName = Paths.get(relativePath, new String[0]).getFileName().toString();
        List filterResultList = lookupSensorList.stream().filter(sensor -> sensor.getSensorBundleEntity().getModuleEntity().getName().contentEquals(moduleName)).filter(sensor -> selectedStr.contains(sensor.getSensorName())).collect(Collectors.toList());
        if (isInstall) {
            List filterRet = filterResultList.stream().filter(ss -> {
                File jFile = new File(ss.getModuleEntity().getJsonFilePath());
                try {
                    String relative = relativePath.toLowerCase().replace("/", File.separator);
                    if (jFile.getCanonicalPath().toLowerCase().contains(relative)) {
                        return true;
                    }
                }
                catch (IOException e) {
                    ISSLogger.w((Exception)e);
                }
                return false;
            }).collect(Collectors.toList());
            selectedSensorList.addAll(filterRet);
        } else {
            selectedSensorList.addAll(filterResultList);
        }
    }

    private void filterLibrary(String selectedStr, List<SelectedItemsDataEntity> selectedSensorList, String relativePath, List<ModuleEntity> libraryList, boolean isInstall) {
        String moduleName = Paths.get(relativePath, new String[0]).getFileName().toString();
        List libs = libraryList.stream().filter(module -> module.getName().contentEquals(moduleName)).filter(module -> selectedStr.contains(module.getName())).collect(Collectors.toList());
        if (isInstall) {
            List filterRet = libs.stream().filter(mm -> {
                File jFile = new File(mm.getJsonFilePath());
                try {
                    String relative = relativePath.toLowerCase().replace("/", File.separator);
                    if (jFile.getCanonicalPath().toLowerCase().contains(relative)) {
                        return true;
                    }
                }
                catch (IOException e) {
                    ISSLogger.w((Exception)e);
                }
                return false;
            }).collect(Collectors.toList());
            selectedSensorList.addAll(filterRet);
        } else {
            selectedSensorList.addAll(libs);
        }
    }
}

