/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads;

import binTools.BinReader;
import binTools.BinWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.payloads.BusPayload;

public class BusPayloadSpi
extends BusPayload {
    public static final int BUS_TYPE = 2;
    private static final int PHASE_BIT = 0;
    private static final int POLARITY_BIT = 1;
    private boolean _csNative;
    private int _csPin;

    public BusPayloadSpi(int busIndex, int busAddress, int busSpeed, boolean csNative, int csPin) {
        super(2, busIndex, busAddress, busSpeed);
        this._csNative = csNative;
        this._csPin = csPin;
    }

    protected BusPayloadSpi(BinReader reader, Element payloadXmlNode) {
        super(reader, payloadXmlNode);
        this.setBusType(2);
        int additionalValue = reader.readNewField((String)"AdditionalValue", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        this._csNative = (additionalValue & 1) > 0;
        this._csPin = (additionalValue & 0x1E) >> 1;
        reader.addComment("AdditionalValue: CsNative = " + this._csNative + "; CsPin = " + this._csPin, payloadXmlNode);
    }

    public BusPayloadSpi(BusPayloadSpi other) {
        super(other);
        this._csNative = other._csNative;
        this._csPin = other._csPin;
    }

    @Override
    public void writeBusData(BinWriter writer, Element parent) {
        this.writeFirstBusFields(writer, parent);
        int additinalValue = 0;
        additinalValue |= this._csNative ? 1 : 0;
        writer.writeNewField("AdditionalValue", 1, additinalValue |= this._csPin << 1, (Node)parent);
        writer.addComment("CsNative = " + this._csNative, parent);
        writer.addComment("AdditionalValue: CsNative = " + this._csNative + "; CsPin = " + this._csPin, parent);
    }

    @Override
    public BusPayload clone() {
        return new BusPayloadSpi(this);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof BusPayloadSpi)) {
            return false;
        }
        BusPayloadSpi other = (BusPayloadSpi)arg0;
        return super.equals(other) && this._csNative == other._csNative && this._csPin == other._csPin;
    }

    @Override
    public boolean isCsNative() {
        return this._csNative;
    }

    public void setCsNative(boolean csNative) {
        this._csNative = csNative;
    }

    @Override
    public int getCsPin() {
        return this._csPin;
    }

    public void setCsPin(int csPin) {
        this._csPin = csPin;
    }

    @Override
    public boolean isEnableRtsCts() {
        return false;
    }

    @Override
    public boolean isIbiEnable() {
        return false;
    }

    @Override
    public int getIbiPurpose() {
        return 0;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

