/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.InterruptsModifierOpener;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.configuration.ConfigurationEditor;
import pdtEditor.gui.configuration.LidModeConfigurationModifier;
import pdtEditor.payloads.Payload;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.payloads.configurations.HumanPresenceStandardConfigurationPayload;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;
import resources.CustomSpinner;

public class HumanPresenceStandardConfiguration
implements InterruptsModifierOpener,
ConfigurationEditor {
    protected Shell shell;
    private Display display;
    private SensorModifier parent;
    private InformationStore infoStore = null;
    private DataStore _dataStore;
    private HumanPresenceStandardConfigurationPayload _payload;
    private boolean _modified = false;
    private ArrayList<Integer> modeIdList = new ArrayList();
    private Combo cmbFormatId;
    private CustomSpinner spnVersion;
    private Group grpDetectRange;
    private Group grpPlmModeId;
    private CustomSpinner spnDetectRangeMax;
    private CustomSpinner spnDetectRangeMin;
    private CustomSpinner spnHingeLow;
    private CustomSpinner spnHingeHigh;
    private Group grpDetectionType;
    private Button btnNonBiometric;
    private Button btnBiometric;
    private Button btnFacialBiometric;
    private Button btnAudioBiometric;
    private Button chkPlmModeIdGroup;
    private Button chkHingeAngle;
    private Button chkScreenAngle;
    private Group grpAttention;
    private Button chkAttention;
    private CustomSpinner spnScreenAngleLow;
    private CustomSpinner spnScreenAngleHigh;
    private static final int DEFAULT_PLM_ROW_CONTROL_COUNT = 15;
    private static final int DEFAULT_PLM_ROW_COUNT = 1;

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.modeIdList = this.getSupportPlmModeIds();
        this.createContents();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shell, 513);
            messageBox.setText("Cannot load file");
            messageBox.setMessage("Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            messageBox.open();
            return;
        }
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public HumanPresenceStandardConfiguration(SensorModifier parentWindow, HumanPresenceStandardConfigurationPayload payload, Sensor sensor) {
        this.parent = parentWindow;
        this._payload = payload;
        this._dataStore = DataStore.getInstance();
    }

    public void setSubCheckboxSelection(Composite parentControl, boolean selection) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            ((Button)control).setSelection(selection);
        }
    }

    public void setChildrenEnable(Composite parentControl, boolean isEnabled) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            control.setEnabled(isEnabled);
        }
    }

    public ArrayList<Integer> getSupportPlmModeIds() {
        ArrayList<Payload> payloads = null;
        ArrayList<LidModeConfigurationPayload.TableEntry> tableEntries = null;
        ArrayList<Integer> supportPlmModeIds = new ArrayList<Integer>();
        if (this._dataStore.getCurrentDevice() == null) {
            return supportPlmModeIds;
        }
        ArrayList<Sensor> sensors = this._dataStore.getCurrentDevice().getSensors();
        for (Sensor sensor : sensors) {
            if (sensor.getLuid().getSensorTypeId() != 768) continue;
            payloads = sensor.getPayloads();
            break;
        }
        if (payloads == null) {
            return supportPlmModeIds;
        }
        for (Payload payload : payloads) {
            if (payload.getClass() != LidModeConfigurationPayload.class) continue;
            tableEntries = ((LidModeConfigurationPayload)payload).getTableEntries();
            break;
        }
        if (tableEntries == null) {
            return supportPlmModeIds;
        }
        for (LidModeConfigurationPayload.TableEntry entry : tableEntries) {
            supportPlmModeIds.add(entry.modeId);
        }
        return supportPlmModeIds;
    }

    protected void createContents() {
        this.shell = new Shell(65760);
        this.shell.setImage(SWTResourceManager.getImage(LidModeConfigurationModifier.class, "/resources/Intel.ico"));
        this.shell.setText("Human Presence Configuration");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Group group = GuiUtils.addGroupToComposite("", (Composite)this.shell, 0, 0, 128, false, false, 1, 1, 4);
        Label lblCalibrationFormatId = GuiUtils.addLabelToComposite("Calibration Format ID:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbFormatId = GuiUtils.addComboToComposite((Composite)group, 12, 4, 16384, true, false, 1, 1);
        Label lblCalibrationVersion = GuiUtils.addLabelToComposite("Calibration Version:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnVersion = GuiUtils.addCustomSpinnerToComposite(CalibrationPayload.VERSION_MAX_VALUE, this.shell, (Composite)group, 2052, 4, 0x1000000, true, false, 1, 1);
        this.cmbFormatId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                HumanPresenceStandardConfiguration.this.upadteControlState();
            }
        });
        this.grpDetectRange = GuiUtils.addGroupToComposite("Detection Range", (Composite)this.shell, 0, 0, 0x1000000, false, false, 1, 1, 6);
        Label lblRangeMax = GuiUtils.addLabelToComposite("Range Max:", (Composite)this.grpDetectRange, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnDetectRangeMax = GuiUtils.addCustomSpinnerToComposite(65535, this.shell, (Composite)this.grpDetectRange, 2048, 16384, 0x1000000, true, true, 1, 1);
        this.spnDetectRangeMax.setMinimum(1001);
        this.spnDetectRangeMax.setSelection(2000);
        Label lblRangeMaxUnit = GuiUtils.addLabelToComposite("mm", (Composite)this.grpDetectRange, 4, 16384, 0x1000000, true, true, 1, 1);
        Label lblRangeMin = GuiUtils.addLabelToComposite("Range Min:", (Composite)this.grpDetectRange, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnDetectRangeMin = GuiUtils.addCustomSpinnerToComposite(499, this.shell, (Composite)this.grpDetectRange, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.spnDetectRangeMin.setSelection(50);
        Label lblRangeMinUnit = GuiUtils.addLabelToComposite("mm", (Composite)this.grpDetectRange, 4, 16384, 0x1000000, false, false, 1, 1);
        Composite cmpHingeAngle = new Composite((Composite)this.shell, 4);
        FormLayout cmpHingeAngleLayout = new FormLayout();
        cmpHingeAngle.setLayout((Layout)cmpHingeAngleLayout);
        cmpHingeAngle.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.chkHingeAngle = new Button(cmpHingeAngle, 32);
        this.chkHingeAngle.setText("Hinge Angle");
        FormData frmDataChkHingeAngleGroup = new FormData();
        this.chkHingeAngle.setLayoutData((Object)frmDataChkHingeAngleGroup);
        frmDataChkHingeAngleGroup.left = new FormAttachment();
        frmDataChkHingeAngleGroup.left.offset = 8;
        this.chkHingeAngle.setSelection(true);
        this.chkHingeAngle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!HumanPresenceStandardConfiguration.this.chkHingeAngle.getSelection()) {
                    HumanPresenceStandardConfiguration.this.spnHingeLow.setSelection(0);
                    HumanPresenceStandardConfiguration.this.spnHingeLow.setEnabled(false);
                    HumanPresenceStandardConfiguration.this.spnHingeHigh.setSelection(360);
                    HumanPresenceStandardConfiguration.this.spnHingeHigh.setEnabled(false);
                } else {
                    HumanPresenceStandardConfiguration.this.spnHingeLow.setEnabled(true);
                    HumanPresenceStandardConfiguration.this.spnHingeHigh.setEnabled(true);
                }
            }
        });
        Group grpHingeAngle = new Group(cmpHingeAngle, 4);
        FormData grpHingeAngleGroupData = new FormData();
        GridLayout grpHingeAngleGroupLayout = new GridLayout(6, false);
        grpHingeAngleGroupLayout.verticalSpacing = 15;
        grpHingeAngleGroupLayout.horizontalSpacing = 12;
        grpHingeAngle.setLayout((Layout)grpHingeAngleGroupLayout);
        grpHingeAngle.setLayoutData((Object)grpHingeAngleGroupData);
        Label lblHingeAngleLow = GuiUtils.addLabelToComposite("Low:", (Composite)grpHingeAngle, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnHingeLow = GuiUtils.addCustomSpinnerToComposite(360, this.shell, (Composite)grpHingeAngle, 2048, 16384, 0x1000000, true, true, 1, 1);
        Label lblHingeLowUnit = GuiUtils.addLabelToComposite("degree", (Composite)grpHingeAngle, 4, 16384, 0x1000000, true, true, 1, 1);
        Label lblHingeAngleHigh = GuiUtils.addLabelToComposite("High:", (Composite)grpHingeAngle, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnHingeHigh = GuiUtils.addCustomSpinnerToComposite(360, this.shell, (Composite)grpHingeAngle, 2048, 16384, 0x1000000, true, true, 1, 1);
        this.spnHingeHigh.setSelection(360);
        Label lblHingeHighUnit = GuiUtils.addLabelToComposite("degree", (Composite)grpHingeAngle, 4, 16384, 0x1000000, true, true, 1, 1);
        Composite cmpScreenAngle = new Composite((Composite)this.shell, 4);
        FormLayout cmpScreenAngleLayout = new FormLayout();
        cmpScreenAngle.setLayout((Layout)cmpScreenAngleLayout);
        cmpScreenAngle.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.chkScreenAngle = new Button(cmpScreenAngle, 32);
        this.chkScreenAngle.setText("Screen Angle");
        FormData frmDataChkScreenAngleGroup = new FormData();
        this.chkScreenAngle.setLayoutData((Object)frmDataChkScreenAngleGroup);
        frmDataChkScreenAngleGroup.left = new FormAttachment();
        frmDataChkScreenAngleGroup.left.offset = 8;
        this.chkScreenAngle.setSelection(true);
        this.chkScreenAngle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!HumanPresenceStandardConfiguration.this.chkScreenAngle.getSelection()) {
                    HumanPresenceStandardConfiguration.this.spnScreenAngleLow.setSelection(0);
                    HumanPresenceStandardConfiguration.this.spnScreenAngleLow.setEnabled(false);
                    HumanPresenceStandardConfiguration.this.spnScreenAngleHigh.setSelection(360);
                    HumanPresenceStandardConfiguration.this.spnScreenAngleHigh.setEnabled(false);
                } else {
                    HumanPresenceStandardConfiguration.this.spnScreenAngleLow.setEnabled(true);
                    HumanPresenceStandardConfiguration.this.spnScreenAngleHigh.setEnabled(true);
                }
            }
        });
        Group grpScreenAngle = new Group(cmpScreenAngle, 4);
        FormData grpScreenAngleGroupData = new FormData();
        GridLayout grpScreenAngleGroupLayout = new GridLayout(6, false);
        grpScreenAngleGroupLayout.verticalSpacing = 15;
        grpScreenAngleGroupLayout.horizontalSpacing = 12;
        grpScreenAngle.setLayout((Layout)grpScreenAngleGroupLayout);
        grpScreenAngle.setLayoutData((Object)grpScreenAngleGroupData);
        Label lblScreenAngleLow = GuiUtils.addLabelToComposite("Low:", (Composite)grpScreenAngle, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnScreenAngleLow = GuiUtils.addCustomSpinnerToComposite(360, this.shell, (Composite)grpScreenAngle, 2048, 16384, 0x1000000, true, true, 1, 1);
        GuiUtils.addLabelToComposite("degree", (Composite)grpScreenAngle, 4, 16384, 0x1000000, true, true, 1, 1);
        Label lblScreenAngleHigh = GuiUtils.addLabelToComposite("High:", (Composite)grpScreenAngle, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnScreenAngleHigh = GuiUtils.addCustomSpinnerToComposite(360, this.shell, (Composite)grpScreenAngle, 2048, 16384, 0x1000000, true, true, 1, 1);
        this.spnScreenAngleHigh.setSelection(360);
        GuiUtils.addLabelToComposite("degree", (Composite)grpScreenAngle, 4, 16384, 0x1000000, true, true, 1, 1);
        Composite cmpPlmModelId = new Composite((Composite)this.shell, 4);
        FormLayout cmpPlmModeIdLayout = new FormLayout();
        cmpPlmModeIdLayout.marginWidth = 5;
        cmpPlmModeIdLayout.marginHeight = 5;
        cmpPlmModelId.setLayout((Layout)cmpPlmModeIdLayout);
        cmpPlmModelId.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.chkPlmModeIdGroup = new Button(cmpPlmModelId, 32);
        this.chkPlmModeIdGroup.setText("PLM Mode ID");
        FormData formData = new FormData();
        this.chkPlmModeIdGroup.setLayoutData((Object)formData);
        formData.left = new FormAttachment();
        formData.left.offset = 8;
        this.grpPlmModeId = new Group(cmpPlmModelId, 4);
        FormData grpPlmModeIdGroupData = new FormData();
        GridLayout plmModeIdGroupLayout = new GridLayout(15, false);
        plmModeIdGroupLayout.verticalSpacing = 15;
        plmModeIdGroupLayout.horizontalSpacing = 15;
        this.grpPlmModeId.setLayout((Layout)plmModeIdGroupLayout);
        if (this.modeIdList == null || this.modeIdList.size() == 0) {
            this.chkPlmModeIdGroup.setSelection(false);
            this.chkPlmModeIdGroup.setEnabled(false);
            Button tempButton = new Button(cmpPlmModelId, 32);
            tempButton.setText("1");
            tempButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            grpPlmModeIdGroupData.width = 15 * tempButton.computeSize((int)-1, (int)-1).x + plmModeIdGroupLayout.horizontalSpacing * 15 + 2 * plmModeIdGroupLayout.marginWidth;
            grpPlmModeIdGroupData.height = 1 * tempButton.computeSize((int)-1, (int)-1).y + plmModeIdGroupLayout.verticalSpacing * 1 + 2 * plmModeIdGroupLayout.marginHeight;
            tempButton.dispose();
        } else {
            this.chkPlmModeIdGroup.setSelection(true);
            for (int i = 0; i < this.modeIdList.size(); ++i) {
                Button addBtn = new Button((Composite)this.grpPlmModeId, 32);
                addBtn.setText(this.modeIdList.get(i).toString());
                addBtn.setData((Object)(1 << this.modeIdList.get(i)));
                addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            }
        }
        this.grpPlmModeId.setLayoutData((Object)grpPlmModeIdGroupData);
        this.chkPlmModeIdGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!HumanPresenceStandardConfiguration.this.chkPlmModeIdGroup.getSelection()) {
                    HumanPresenceStandardConfiguration.this.setSubCheckboxSelection((Composite)HumanPresenceStandardConfiguration.this.grpPlmModeId, false);
                    HumanPresenceStandardConfiguration.this.setChildrenEnable((Composite)HumanPresenceStandardConfiguration.this.grpPlmModeId, false);
                } else {
                    HumanPresenceStandardConfiguration.this.setChildrenEnable((Composite)HumanPresenceStandardConfiguration.this.grpPlmModeId, true);
                }
            }
        });
        this.grpAttention = GuiUtils.addGroupToComposite("", (Composite)this.shell, 4, 4, 0x1000000, true, false, 1, 1, 1);
        this.chkAttention = GuiUtils.addButtonToComposite("Attention", "", (Composite)this.grpAttention, 32, 16384, 0x1000000, false, false, 1, 1);
        this.grpDetectionType = GuiUtils.addGroupToComposite("Detection Type", (Composite)this.shell, 4, 4, 0x1000000, true, false, 1, 1, 4);
        Link overallDescrtiption = new Link((Composite)this.grpDetectionType, 4);
        overallDescrtiption.setText("According to Windows requirement, OEM/ODM must configure below properties properly based on the type of \r\ntechnology used by the sensor, ISH will report these properties to Windows and indicate if the sensor is I using\r\nany privacy-sensitive visual and audio sensing technologies. For detail requirements, please refer to this link:\r\n<a>https://www.ilga.gov/legislation/ilcs/ilcs3.asp?ActID=3004&ChapterID=57</a>\r\nGeneral guideline in configuring below properties is to follow the \\\"highest/worst\\\" privacy assumption, if the\r\ntechnology is capable to detect face, set \\\"Facial Biometric\\\"; if the technology is capable to detect audio, set\r\n\"Audio Biometric\". For any further clarifications, please contact Intel, and we can bridge the question to MSFT\r\n contact who defines these properties.");
        overallDescrtiption.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        overallDescrtiption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"https://www.ilga.gov/legislation/ilcs/ilcs3.asp?ActID=3004&ChapterID=57");
            }
        });
        this.btnNonBiometric = new Button((Composite)this.grpDetectionType, 32);
        this.btnNonBiometric.setText("Vendor-Defined Non-Biometric");
        this.btnNonBiometric.setData((Object)1);
        this.btnNonBiometric.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnNonBiometric.setToolTipText("Presence (of one or more people) is detected utilizing a vendor-defined,\r\nbut non-biometric method. This is used to give positive affirmation that\r\nthe sensor is using detection unrelated to biometrics as defined below.\r\nWithout this, a Host cannot assume biometrics aren't utilized by the device.");
        this.btnBiometric = new Button((Composite)this.grpDetectionType, 32);
        this.btnBiometric.setText("Vendor-Defined Biometric");
        this.btnBiometric.setData((Object)2);
        this.btnBiometric.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnBiometric.setToolTipText("Presence (of one or more people) is detected utilizing vendor-defined\r\nhuman biometrics. This is a catch-all for a Human Presence sensor that\r\nutilizes biometrics not already defined.");
        this.btnFacialBiometric = new Button((Composite)this.grpDetectionType, 32);
        this.btnFacialBiometric.setText("Facial Biometric");
        this.btnFacialBiometric.setData((Object)4);
        this.btnFacialBiometric.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnFacialBiometric.setToolTipText("Human presence is detected by scanning (e.g. by a low-resolution video camera)\r\nfor human faces (e.g. using Viola-Jones object detection). Distinguishing between\r\nfaces or detection of facial attributes is not performed. Such detection is similar\r\nto that of existing digital cameras that can place a bounding-box around a face.");
        this.btnAudioBiometric = new Button((Composite)this.grpDetectionType, 32);
        this.btnAudioBiometric.setText("Audio Biometric");
        this.btnAudioBiometric.setData((Object)8);
        this.btnAudioBiometric.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnAudioBiometric.setToolTipText("Human presence is detected by scanning (e.g. by a microphone) for 'human' sounds\r\n(e.g. a predefined keyword, general talking, loud noises, clapping). Distinguishing\r\nbetween voices/users or detection of audio characteristics are not performed.");
        this.btnNonBiometric.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HumanPresenceStandardConfiguration.this.updateDetectTypeCheckbox();
            }
        });
        this.btnBiometric.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HumanPresenceStandardConfiguration.this.updateDetectTypeCheckbox();
            }
        });
        this.btnFacialBiometric.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HumanPresenceStandardConfiguration.this.updateDetectTypeCheckbox();
            }
        });
        this.btnAudioBiometric.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HumanPresenceStandardConfiguration.this.updateDetectTypeCheckbox();
            }
        });
        ((GridData)this.grpDetectionType.getLayoutData()).exclude = true;
        this.grpDetectionType.setVisible(false);
        Composite cmpsOkCancel = new Composite((Composite)this.shell, 0);
        cmpsOkCancel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 5;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        cmpsOkCancel.setLayout((Layout)gridLayout);
        Button btnOk = new Button(cmpsOkCancel, 0);
        GridData gd_btnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
        btnOk.setLayoutData((Object)gd_btnOk);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnOk.setText("OK");
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HumanPresenceStandardConfiguration.this.save();
            }
        });
        Button btnCancel = new Button(cmpsOkCancel, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnCancel.setText("Cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HumanPresenceStandardConfiguration.this.shell.close();
            }
        });
        Point pLblCalibrationFormatId = lblCalibrationFormatId.computeSize(-1, -1);
        Point plbLRangeMaxUnit = lblRangeMaxUnit.computeSize(-1, -1);
        Point pLblCalibrationVersion = lblCalibrationVersion.computeSize(-1, -1);
        Point pLblHingeLowUnit = lblHingeLowUnit.computeSize(-1, -1);
        Point pLblHingeHighUnit = lblHingeHighUnit.computeSize(-1, -1);
        int longSpinnerMinWidth = GuiUtils.getButtonWidth((Control)this.shell) * 1;
        ((GridData)lblRangeMaxUnit.getLayoutData()).widthHint = pLblHingeLowUnit.x;
        ((GridData)lblRangeMinUnit.getLayoutData()).widthHint = pLblHingeHighUnit.x;
        ((GridData)lblRangeMax.getLayoutData()).widthHint = pLblCalibrationFormatId.x;
        ((GridData)lblRangeMin.getLayoutData()).widthHint = pLblCalibrationVersion.x;
        ((GridData)this.spnDetectRangeMax.getLayoutData()).widthHint = longSpinnerMinWidth;
        ((GridData)this.spnDetectRangeMin.getLayoutData()).widthHint = longSpinnerMinWidth;
        ((GridData)this.cmbFormatId.getLayoutData()).widthHint = longSpinnerMinWidth + plbLRangeMaxUnit.x + 35;
        ((GridData)this.spnVersion.getLayoutData()).widthHint = longSpinnerMinWidth + pLblHingeHighUnit.x + 10;
        ((GridData)lblHingeAngleLow.getLayoutData()).widthHint = pLblCalibrationFormatId.x;
        ((GridData)this.spnHingeLow.getLayoutData()).widthHint = longSpinnerMinWidth;
        ((GridData)lblHingeAngleHigh.getLayoutData()).widthHint = pLblCalibrationVersion.x;
        ((GridData)this.spnHingeHigh.getLayoutData()).widthHint = longSpinnerMinWidth;
        ((GridData)lblScreenAngleLow.getLayoutData()).widthHint = pLblCalibrationFormatId.x;
        ((GridData)this.spnScreenAngleLow.getLayoutData()).widthHint = longSpinnerMinWidth;
        ((GridData)lblScreenAngleHigh.getLayoutData()).widthHint = pLblCalibrationVersion.x;
        ((GridData)this.spnScreenAngleHigh.getLayoutData()).widthHint = longSpinnerMinWidth;
        this.grpDetectRange.computeSize(-1, -1);
        this.grpDetectionType.computeSize(-1, -1);
        group.computeSize(-1, -1);
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }

    public void upadteControlState() {
        boolean plmModeIdEnabled = true;
        boolean plmModeIdSelection = true;
        if (Integer.valueOf(this.cmbFormatId.getText()) == 4) {
            plmModeIdEnabled = true;
            plmModeIdSelection = true;
            this.btnNonBiometric.setEnabled(true);
            this.btnBiometric.setEnabled(true);
            this.btnAudioBiometric.setEnabled(true);
            this.btnFacialBiometric.setEnabled(true);
            this.spnHingeHigh.setEnabled(true);
            this.spnHingeLow.setEnabled(true);
            this.setChildrenEnable((Composite)this.grpPlmModeId, true);
            this.updateDetectTypeCheckbox();
            this.chkAttention.setEnabled(true);
            this.chkHingeAngle.setSelection(true);
            this.chkHingeAngle.setEnabled(true);
            this.chkScreenAngle.setSelection(true);
            this.chkScreenAngle.setEnabled(true);
            this.spnScreenAngleLow.setEnabled(true);
            this.spnScreenAngleHigh.setEnabled(true);
        } else if (Integer.valueOf(this.cmbFormatId.getText()) == 3) {
            plmModeIdEnabled = true;
            plmModeIdSelection = true;
            this.btnNonBiometric.setEnabled(true);
            this.btnBiometric.setEnabled(true);
            this.btnAudioBiometric.setEnabled(true);
            this.btnFacialBiometric.setEnabled(true);
            this.spnHingeHigh.setEnabled(true);
            this.spnHingeLow.setEnabled(true);
            this.setChildrenEnable((Composite)this.grpPlmModeId, true);
            this.updateDetectTypeCheckbox();
            this.chkAttention.setEnabled(true);
            this.chkHingeAngle.setSelection(true);
            this.chkHingeAngle.setEnabled(true);
            this.chkScreenAngle.setSelection(false);
            this.chkScreenAngle.setEnabled(false);
            this.spnScreenAngleLow.setEnabled(false);
            this.spnScreenAngleHigh.setEnabled(false);
            this.spnScreenAngleLow.setSelection(0);
            this.spnScreenAngleHigh.setSelection(360);
        } else if (Integer.valueOf(this.cmbFormatId.getText()) == 2) {
            plmModeIdEnabled = true;
            plmModeIdSelection = true;
            this.btnNonBiometric.setEnabled(true);
            this.btnBiometric.setEnabled(true);
            this.btnAudioBiometric.setEnabled(true);
            this.btnFacialBiometric.setEnabled(true);
            this.spnHingeHigh.setEnabled(true);
            this.spnHingeLow.setEnabled(true);
            this.setChildrenEnable((Composite)this.grpPlmModeId, true);
            this.updateDetectTypeCheckbox();
            this.chkAttention.setEnabled(false);
            this.chkAttention.setSelection(false);
            this.chkHingeAngle.setSelection(true);
            this.chkHingeAngle.setEnabled(true);
            this.chkScreenAngle.setSelection(false);
            this.chkScreenAngle.setEnabled(false);
            this.spnScreenAngleLow.setEnabled(false);
            this.spnScreenAngleHigh.setEnabled(false);
            this.spnScreenAngleLow.setSelection(0);
            this.spnScreenAngleHigh.setSelection(360);
        } else if (Integer.valueOf(this.cmbFormatId.getText()) == 1) {
            plmModeIdEnabled = false;
            plmModeIdSelection = false;
            this.btnNonBiometric.setEnabled(true);
            this.btnBiometric.setEnabled(true);
            this.btnAudioBiometric.setEnabled(true);
            this.btnFacialBiometric.setEnabled(true);
            this.spnHingeLow.setEnabled(false);
            this.spnHingeHigh.setEnabled(false);
            this.spnHingeLow.setSelection(0);
            this.spnHingeHigh.setSelection(360);
            this.setSubCheckboxSelection((Composite)this.grpPlmModeId, false);
            this.setChildrenEnable((Composite)this.grpPlmModeId, false);
            this.updateDetectTypeCheckbox();
            this.chkAttention.setEnabled(false);
            this.chkAttention.setSelection(false);
            this.chkHingeAngle.setSelection(false);
            this.chkHingeAngle.setEnabled(false);
            this.chkScreenAngle.setSelection(false);
            this.chkScreenAngle.setEnabled(false);
            this.spnScreenAngleLow.setEnabled(false);
            this.spnScreenAngleHigh.setEnabled(false);
            this.spnScreenAngleLow.setSelection(0);
            this.spnScreenAngleHigh.setSelection(360);
        } else {
            plmModeIdEnabled = false;
            plmModeIdSelection = false;
            this.btnNonBiometric.setEnabled(false);
            this.btnBiometric.setEnabled(false);
            this.btnAudioBiometric.setEnabled(false);
            this.btnFacialBiometric.setEnabled(false);
            this.btnNonBiometric.setSelection(false);
            this.btnBiometric.setSelection(false);
            this.btnAudioBiometric.setSelection(false);
            this.btnFacialBiometric.setSelection(false);
            this.spnHingeHigh.setEnabled(false);
            this.spnHingeLow.setEnabled(false);
            this.spnHingeLow.setSelection(0);
            this.spnHingeHigh.setSelection(360);
            this.setSubCheckboxSelection((Composite)this.grpPlmModeId, false);
            this.setChildrenEnable((Composite)this.grpPlmModeId, false);
            this.chkAttention.setEnabled(false);
            this.chkAttention.setSelection(false);
            this.chkHingeAngle.setSelection(false);
            this.chkHingeAngle.setEnabled(false);
            this.chkScreenAngle.setSelection(false);
            this.chkScreenAngle.setEnabled(false);
            this.spnScreenAngleLow.setEnabled(false);
            this.spnScreenAngleHigh.setEnabled(false);
            this.spnScreenAngleLow.setSelection(0);
            this.spnScreenAngleHigh.setSelection(360);
        }
        if (this.modeIdList != null && this.modeIdList.size() > 0) {
            this.chkPlmModeIdGroup.setSelection(plmModeIdSelection);
            this.chkPlmModeIdGroup.setEnabled(plmModeIdEnabled);
        }
    }

    public void updateDetectTypeCheckbox() {
        if (this.btnNonBiometric.getSelection()) {
            this.btnAudioBiometric.setEnabled(false);
            this.btnBiometric.setEnabled(false);
            this.btnFacialBiometric.setEnabled(false);
            this.btnAudioBiometric.setSelection(false);
            this.btnBiometric.setSelection(false);
            this.btnFacialBiometric.setSelection(false);
        } else {
            this.btnAudioBiometric.setEnabled(true);
            this.btnBiometric.setEnabled(true);
            this.btnFacialBiometric.setEnabled(true);
        }
        if (this.btnAudioBiometric.getSelection() || this.btnBiometric.getSelection() || this.btnFacialBiometric.getSelection()) {
            this.btnNonBiometric.setEnabled(false);
            this.btnNonBiometric.setSelection(false);
        } else {
            this.btnNonBiometric.setEnabled(true);
        }
    }

    public void fillData() {
        int[] allFormatId = HumanPresenceStandardConfigurationPayload.getAllSupportFormatId();
        for (int i = 0; i < allFormatId.length; ++i) {
            this.cmbFormatId.add(Integer.toString(allFormatId[i]));
            if (this._payload == null || allFormatId[i] != this._payload.getFormatID()) continue;
            this.cmbFormatId.select(i);
        }
        if (this._payload == null) {
            this.cmbFormatId.select(this.cmbFormatId.getItems().length - 1);
            this.spnVersion.setSelection(0);
            return;
        }
        this.spnVersion.setSelection(this._payload.getVersion());
        this.spnDetectRangeMax.setSelection(this._payload.getDetetctRangeMax());
        this.spnDetectRangeMin.setSelection(this._payload.getDetetctRangeMin());
        if (this._payload.getFormatID() >= 1) {
            this.setCheckBoxSelectByDetectionType(this.btnNonBiometric, this._payload.getDetectionType());
            this.setCheckBoxSelectByDetectionType(this.btnBiometric, this._payload.getDetectionType());
            this.setCheckBoxSelectByDetectionType(this.btnAudioBiometric, this._payload.getDetectionType());
            this.setCheckBoxSelectByDetectionType(this.btnFacialBiometric, this._payload.getDetectionType());
            this.updateDetectTypeCheckbox();
        }
        if (this._payload.getFormatID() >= 2) {
            this.spnHingeLow.setSelection(this._payload.hingeAngleLow);
            this.spnHingeHigh.setSelection(this._payload.hingeAngleHigh);
            if (this._payload.hingeAngleLow == 0 && this._payload.hingeAngleHigh == 360) {
                this.chkHingeAngle.setSelection(false);
                this.chkHingeAngle.notifyListeners(13, new Event());
            }
            if (this._payload.plmModeId == -1) {
                this.chkPlmModeIdGroup.setSelection(false);
                this.chkPlmModeIdGroup.notifyListeners(13, new Event());
            } else {
                this.chkPlmModeIdGroup.setSelection(true);
                this.setChildrenCheckboxBySelectedData((Composite)this.grpPlmModeId, this._payload.plmModeId);
            }
        }
        if (this._payload.getFormatID() >= 3) {
            this.chkAttention.setSelection(this._payload.isAttention());
        }
        if (this._payload.getFormatID() >= 4) {
            this.spnScreenAngleLow.setSelection(this._payload.getScreenAngleLow());
            this.spnScreenAngleHigh.setSelection(this._payload.getScreenAngleHigh());
            if (this._payload.getScreenAngleLow() == 0 && this._payload.getScreenAngleHigh() == 360) {
                this.chkScreenAngle.setSelection(false);
                this.chkScreenAngle.notifyListeners(13, new Event());
            }
        }
    }

    public void setChildrenCheckboxBySelectedData(Composite parentControl, int data) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0) continue;
            int bitValue = (Integer)control.getData();
            if ((bitValue & data) > 0) {
                ((Button)control).setSelection(true);
                continue;
            }
            ((Button)control).setSelection(false);
        }
    }

    public void setCheckBoxSelectByDetectionType(Button checkBox, int detectionType) {
        if (((Integer)checkBox.getData() & detectionType) > 0) {
            checkBox.setSelection(true);
        } else {
            checkBox.setSelection(false);
        }
    }

    public int getDetectionTypeFromCheckBox(Button checkBox) {
        int ret = 0;
        if (checkBox.getSelection()) {
            ret = (Integer)checkBox.getData();
        }
        return ret;
    }

    public int getChildrenCheckboxSelectedDataAsInt(Composite parentControl) {
        Control[] child = parentControl.getChildren();
        int ret = 0;
        for (Control control : child) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0 || !((Button)control).getSelection()) continue;
            int value = (Integer)control.getData();
            ret |= value;
        }
        if (ret == 0) {
            ret = -1;
        }
        return ret;
    }

    public void save() {
        boolean newConfiguration = false;
        if (this._payload == null) {
            this._payload = new HumanPresenceStandardConfigurationPayload();
            newConfiguration = true;
        }
        this._payload.setFormatID(Integer.valueOf(this.cmbFormatId.getText()));
        this._payload.setVersion(this.spnVersion.getSelection());
        this._payload.setDetetctRangeMax(this.spnDetectRangeMax.getSelection());
        this._payload.setDetetctRangeMin(this.spnDetectRangeMin.getSelection());
        if (this._payload.getFormatID() >= 2) {
            if (this.chkHingeAngle.getSelection()) {
                this._payload.hingeAngleHigh = this.spnHingeHigh.getSelection();
                this._payload.hingeAngleLow = this.spnHingeLow.getSelection();
            } else {
                this._payload.hingeAngleLow = 0;
                this._payload.hingeAngleHigh = 360;
            }
            this._payload.plmModeId = this.getChildrenCheckboxSelectedDataAsInt((Composite)this.grpPlmModeId);
        }
        if (this._payload.getFormatID() >= 1) {
            int detectionType = this.getDetectionTypeFromCheckBox(this.btnNonBiometric);
            detectionType |= this.getDetectionTypeFromCheckBox(this.btnBiometric);
            detectionType |= this.getDetectionTypeFromCheckBox(this.btnAudioBiometric);
            this._payload.setDetectionType(1);
            this._payload.setDetectionType(detectionType |= this.getDetectionTypeFromCheckBox(this.btnFacialBiometric));
        } else {
            this._payload.setDetectionType(0);
        }
        if (this._payload.getFormatID() >= 3) {
            this._payload.setAttention(this.chkAttention.getSelection());
        }
        if (this._payload.getFormatID() >= 4) {
            if (this.chkScreenAngle.getSelection()) {
                this._payload.setScreenAngleLow(this.spnScreenAngleLow.getSelection());
                this._payload.setScreenAngleHigh(this.spnScreenAngleHigh.getSelection());
            } else {
                this._payload.setScreenAngleLow(0);
                this._payload.setScreenAngleHigh(360);
            }
        }
        if (newConfiguration && this.parent != null) {
            this.parent.addNewConfiguration(this._payload);
        }
        this._modified = false;
        if (this.parent != null) {
            this.parent.setModified();
        }
        this.shell.close();
    }

    @Override
    public int getGpioCount() {
        return 0;
    }

    @Override
    public int[] getGpioSelectionIndices() {
        return null;
    }

    @Override
    public HashMap<String, String> getLineValues(int lineIndex) {
        return null;
    }

    @Override
    public void addGpioToTable(String purposeID, String pinNumber, String modelGpio) {
    }

    @Override
    public void updateGpioLine(int lineIndex, HashMap<String, String> values) {
    }

    @Override
    public Shell getShell() {
        return null;
    }

    @Override
    public void setModified() {
    }

    @Override
    public String getConfigurationFormatName() {
        return "Human Presence Calibrated Configuration";
    }
}

