/*
 * Decompiled with CFR 0.152.
 */
package manager.configure;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import manager.common.APIVersion;
import manager.configure.Platform;
import manager.utils.ManagerFileUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="Firmware")
public class Firmware {
    @XmlElement
    private String version;
    @XmlElement
    private String flag;
    public static final String FDK = "FDK";
    public static final String USER = "USER";
    public static final String SWAP = "SWAP";
    @XmlTransient
    private APIVersion apiVersion;
    @XmlTransient
    private Platform platform;

    public Firmware() {
    }

    public Firmware(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getFlag() {
        return this.flag;
    }

    public boolean isFDKInstalled() {
        return this.flag.equals(FDK);
    }

    public void setUserInstalled() {
        this.flag = USER;
    }

    public void setSWAPInstalled() {
        this.flag = SWAP;
    }

    public void setPlatform(Platform plat) {
        this.platform = plat;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getPath() {
        if (this.platform != null) {
            try {
                return String.valueOf(ManagerFileUtils.FDK_TOOLS_VERSION_FOLDER(this.platform)) + File.separator + this.version;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String dump() {
        return "[" + this.version + "|" + this.flag + "|" + this.getPath() + "]";
    }

    public APIVersion getAPIVersion(String firmwarePath) {
        block11: {
            try {
                String filePath;
                if (firmwarePath == null || firmwarePath.isEmpty()) {
                    firmwarePath = ManagerFileUtils.FDK_SIMICS_FOLDER();
                }
                if (!new File(filePath = String.valueOf(firmwarePath) + File.separator + "versions" + File.separator + this.platform.getName() + File.separator + this.version + File.separator + "include" + File.separator + "sensor_app" + File.separator + "sc_api.h").exists()) break block11;
                FileInputStream fs = new FileInputStream(filePath);
                BufferedReader buf = new BufferedReader(new InputStreamReader(new DataInputStream(fs)));
                String major = null;
                String minor = null;
                String patch = null;
                try {
                    String line;
                    while ((line = buf.readLine()) != null) {
                        if (line.contains("SC_SENSOR_CORE_API_VER_MAJOR")) {
                            major = this.getValue(line, "SC_SENSOR_CORE_API_VER_MAJOR");
                            continue;
                        }
                        if (line.contains("SC_SENSOR_CORE_API_VER_MINOR")) {
                            minor = this.getValue(line, "SC_SENSOR_CORE_API_VER_MINOR");
                            continue;
                        }
                        if (!line.contains("SC_SENSOR_CORE_API_VER_PATCH")) continue;
                        patch = this.getValue(line, "SC_SENSOR_CORE_API_VER_PATCH");
                    }
                    this.apiVersion = new APIVersion(String.valueOf(major) + "." + minor + "." + patch);
                }
                finally {
                    if (fs != null) {
                        fs.close();
                    }
                }
                buf.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.apiVersion == null) {
            return APIVersion.emptyVersion;
        }
        return this.apiVersion;
    }

    public APIVersion getAPIVersion() {
        if (this.apiVersion == null) {
            String firmwarePath;
            try {
                firmwarePath = ManagerFileUtils.FDK_TOOLS_FOLDER();
            }
            catch (Exception e) {
                return APIVersion.emptyVersion;
            }
            if (firmwarePath.isEmpty()) {
                return APIVersion.emptyVersion;
            }
            return this.getAPIVersion(firmwarePath);
        }
        return this.apiVersion;
    }

    private String getValue(String line, String tag) {
        int index = line.indexOf(tag);
        String value = line.substring(index + tag.length());
        while (value.startsWith(" ") || value.startsWith("\t")) {
            value = value.substring(1);
        }
        return value;
    }

    public void setAPIVersion(APIVersion version) {
        this.apiVersion = version;
    }

    public String toString() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Firmware)) {
            return false;
        }
        Firmware fm = (Firmware)obj;
        return fm.getVersion().equals(this.version);
    }
}

