/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.BoardDescriptionTable;
import pdtEditor.payloads.BusPayload;

public class HeciConfigurationTable
extends BoardDescriptionTable {
    public static final int BDT_TYPE = 1;
    private BusPayload _bus = null;

    public HeciConfigurationTable() {
        this.setType(1);
    }

    public HeciConfigurationTable(BinReader reader, Element payloadXmlNode) {
        this.setType(1);
        Element busElement = reader.readNewField((String)"BusInfo", (Node)payloadXmlNode).xmlElement;
        this._bus = BusPayload.newBusPayload(reader, busElement);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        writer.writeNewField("Type", 1, this.getType(), (Node)parent);
        Common.Field lengthField = writer.writeNewField("Length", 2, 0, (Node)parent);
        writer.addSizeCounter(lengthField);
        if (this._bus != null) {
            this._bus.writeBusData(writer, parent);
        }
        writer.removeSizeCounter(lengthField);
    }

    public BusPayload getBus() {
        return this._bus;
    }

    public void setBus(BusPayload bus) {
        this._bus = bus;
    }
}

