/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.common.exceptions;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    public static String parseException(Exception e) {
        String ret = "\n  ";
        if (e != null && e.getMessage() != null) {
            ret = String.valueOf(ret) + "Exception: ";
            ret = String.valueOf(ret) + e.getMessage().replaceAll("\n  ", "\n    ");
        }
        return ret;
    }

    public static String parseException(Exception e, String general) {
        String ret = ExceptionHandler.parseException(e);
        if (ret != "\n  ") {
            return ret;
        }
        return general;
    }

    public static void HandleException(Exception ex) {
        String err = ExceptionHandler.parseException(ex, "An internal error occured.");
        ExceptionHandler.ShowMessage("Intel ISS Plugin Error", err, 1);
    }

    public static void HandleExceptionInSeparateThread(Exception ex) {
        String err = ExceptionHandler.parseException(ex, "An internal error occured.");
        ExceptionHandler.ShowMessageInSeparateThread("Intel ISS Plugin Error", err, 1);
    }

    public static void HandleException(Exception ex, Shell shell) {
        String err = ExceptionHandler.parseException(ex, "An internal error occured.");
        ExceptionHandler.ShowMessage(shell, "Intel ISS Plugin Error", err, 1);
    }

    public static int ShowMessage(String hdr, String msg, int style) {
        Shell shell = new Shell(Display.getCurrent());
        return ExceptionHandler.ShowMessage(shell, hdr, msg, style);
    }

    public static void ShowMessageInSeparateThread(final String hdr, final String msg, final int style) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell(Display.getCurrent());
                ExceptionHandler.ShowMessage(shell, hdr, msg, style);
            }
        });
    }

    public static int ShowMessage(Shell shell, String hdr, String msg, int style) {
        MessageBox messageBox = new MessageBox(shell, style);
        messageBox.setText(hdr);
        if (msg == null) {
            messageBox.setMessage("Unknow Exception.");
        } else {
            messageBox.setMessage(msg);
        }
        return messageBox.open();
    }
}

