//
//  hwInterfaceMacOs.h
//  SimpleDriver
//
//  Created by Egor Pomozov on 07.12.14.
//  Copyright (c) 2014 Aquantia Corp. All rights reserved.
//
//  OS X-specific parts split from SimpleControl.h
//

#ifndef hwInterfaceMacOs_
#define hwInterfaceMacOs_

#include <Python/Python.h>
#include <sys/queue.h>
#include <stdatomic.h>

#include <mach/boolean.h>

// bcopy("Attempting re-initialize in HW_Initialize()", HW_ErrorMessage, ERROR_MESSAGE_SIZE)
#define STRING_COPY(var,size,msg) bcopy(msg, var, size)
// snprintf( HW_ErrorMessage, ERROR_MESSAGE_SIZE, "Failed to initialize driver in HW_Initialize() 0x%08X", res);
#define STRING_PRINTF(...) snprintf(__VA_ARGS__)
#define FUNCTION_NAME __FUNCTION__

//Add WIN32 compatibility
#define HRESULT int32_t
#ifdef __COREFOUNDATION_CFPLUGINCOM__
#undef SUCCEEDED
#undef FAILED
#undef S_OK
#undef E_FAIL
#endif

#define SUCCEEDED(r)   (((HRESULT)(r)) >= 0)
#define FAILED(r) (r != EXIT_SUCCESS)

/* #define FAILED(r) (r == EXIT_FAILURE) */
#define S_OK EXIT_SUCCESS
#define E_FAIL EXIT_FAILURE

#define UNREFERENCED_PARAMETER(x)

#define LOBYTE(x) (x & 0xFF)
#define HIBYTE(x) ((x >> 8) & 0xFF)

#define LOWORD(x) (x & 0xFFFF)
#define HIWORD(x) ((x >> 16) & 0xFFFF)

#define LODWORD(x) (((uint32_t *)&x)[0])
#define HIDWORD(x) (((uint32_t *)&x)[1])

#define _In_
#define _Out_
#define _Inout_

#endif
