/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ByteEditor
extends Composite {
    private static String BYTE_EDITOR_BUTTON_DATA_KEY_INDEX = "index";
    Button btnChkTitle;
    Group grpMain;
    private List<Button> buttonList = new ArrayList<Button>();
    private List<String> buttonTextList = new ArrayList<String>();
    private String title = "Unknown";
    private long selectValue = 0L;
    private int bytesCount = 2;
    private Vector<ModifyListener> modifyListeners = new Vector();
    boolean isShowCheckBox = false;
    private PaintListener buttonPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Button current = (Button)e.widget;
        }
    };
    private SelectionListener byteButtonSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Button currentButton = (Button)e.widget;
            int index = (Integer)currentButton.getData(BYTE_EDITOR_BUTTON_DATA_KEY_INDEX);
            int byteValue = 1 << index;
            if (currentButton.getSelection()) {
                ByteEditor.this.selectValue |= byteValue;
            } else {
                ByteEditor.this.selectValue = ByteEditor.this.selectValue ^ (long)byteValue;
            }
            ByteEditor.this.updateTitle();
            if (ByteEditor.this.isShowCheckBox) {
                if (ByteEditor.this.selectValue == -1L && !ByteEditor.this.btnChkTitle.getSelection()) {
                    ByteEditor.this.btnChkTitle.setSelection(true);
                } else if (ByteEditor.this.selectValue != -1L && ByteEditor.this.btnChkTitle.getSelection()) {
                    ByteEditor.this.btnChkTitle.setSelection(false);
                }
            }
            ByteEditor.this.fireModifyListener();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private SelectionListener selectAllButtonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (ByteEditor.this.btnChkTitle.getSelection()) {
                for (Button btnTemp : ByteEditor.this.buttonList) {
                    btnTemp.setSelection(true);
                }
                ByteEditor.this.selectValue = -1L;
                ByteEditor.this.updateTitle();
            } else {
                for (Button btnTemp : ByteEditor.this.buttonList) {
                    btnTemp.setSelection(false);
                }
                ByteEditor.this.selectValue = 0L;
                ByteEditor.this.updateTitle();
            }
            ByteEditor.this.fireModifyListener();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.addElement(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.removeElement(listener);
    }

    public void fireModifyListener() {
        Event event = new Event();
        event.display = this.getDisplay();
        event.widget = this;
        ModifyEvent modifyEvent = new ModifyEvent(event);
        for (int i = 0; i < this.modifyListeners.size(); ++i) {
            ModifyListener listener = this.modifyListeners.elementAt(i);
            listener.modifyText(modifyEvent);
        }
    }

    public ByteEditor(Composite parent, int style) {
        super(parent, style);
        this.createContent(parent);
    }

    public ByteEditor(Composite parent, int style, int bytesNumber) {
        super(parent, style);
        this.bytesCount = bytesNumber;
        this.createContent(parent);
    }

    public void setEnabled(boolean enabled) {
        for (Button button : this.buttonList) {
            button.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    private void createContent(Composite parent) {
        int horizontalSpan = 8;
        Group main = null;
        if (this.bytesCount > 2) {
            horizontalSpan = 16;
        }
        if (this.isShowCheckBox) {
            Composite cmpMain = new Composite((Composite)this, 4);
            GridData gdMain = new GridData(4, 4, true, true);
            GridLayout gdlMain = new GridLayout(horizontalSpan, true);
            gdlMain.marginWidth = 0;
            gdlMain.marginHeight = 0;
            gdlMain.horizontalSpacing = 0;
            gdlMain.verticalSpacing = 0;
            gdMain.verticalIndent = 0;
            cmpMain.setLayoutData((Object)gdMain);
            cmpMain.setLayout((Layout)gdlMain);
            this.btnChkTitle = new Button(cmpMain, 32);
            GridData gdTitle = new GridData();
            gdTitle.horizontalSpan = horizontalSpan;
            gdTitle.horizontalIndent = 4;
            gdTitle.minimumWidth = 300;
            gdTitle.grabExcessHorizontalSpace = true;
            this.btnChkTitle.setLayoutData((Object)gdTitle);
            this.btnChkTitle.addSelectionListener(this.selectAllButtonListener);
            this.updateTitle();
        } else {
            this.grpMain = new Group((Composite)this, 4);
            GridData gdMain = new GridData(4, 4, true, true);
            GridLayout gdlMain = new GridLayout(horizontalSpan, true);
            gdlMain.marginWidth = 0;
            gdlMain.marginHeight = 0;
            gdlMain.horizontalSpacing = 0;
            gdlMain.verticalSpacing = 0;
            gdMain.verticalIndent = 0;
            this.grpMain.setLayoutData((Object)gdMain);
            this.grpMain.setText(this.title);
            this.grpMain.setLayout((Layout)gdlMain);
            main = this.grpMain;
        }
        for (int i = 0; i < this.bytesCount * 8; ++i) {
            Button btnTemp = new Button((Composite)main, 0x1000002);
            GridData gdButton = new GridData();
            gdButton.horizontalAlignment = 4;
            gdButton.minimumWidth = 40;
            gdButton.grabExcessHorizontalSpace = true;
            btnTemp.addSelectionListener(this.byteButtonSelectionListener);
            btnTemp.setLayoutData((Object)gdButton);
            btnTemp.setData(BYTE_EDITOR_BUTTON_DATA_KEY_INDEX, (Object)i);
            this.buttonList.add(btnTemp);
            this.buttonTextList.add("");
        }
    }

    public void clearAllButtonText() {
        for (int i = 0; i < this.buttonList.size(); ++i) {
            this.setButtonText("", i);
        }
    }

    public void setTitle(String text) {
        this.title = text;
        this.updateTitle();
    }

    public void setButtonText(List<String> testList) {
        for (int i = 0; i < testList.size(); ++i) {
            this.buttonTextList.set(i, testList.get(i));
            this.buttonList.get(i).setText(this.buttonTextList.get(i));
        }
    }

    public void setButtonText(String text, int index) {
        this.buttonTextList.set(index, text);
        this.buttonList.get(index).setText(text);
        this.pack();
    }

    private void updateTitle() {
        if (!this.isShowCheckBox) {
            this.grpMain.setText(this.title);
            return;
        }
        String format = "%0" + this.bytesCount * 2 + "X";
        String temp = "";
        temp = this.bytesCount == 1 ? this.title + " (" + String.format(format, (byte)this.selectValue) + ")" : (this.bytesCount == 2 ? this.title + " (" + String.format(format, (short)this.selectValue) + ")" : this.title + " (" + String.format(format, this.selectValue) + ")");
        this.btnChkTitle.setText(temp);
        this.btnChkTitle.pack();
    }

    public void setBitSelection(int offset, boolean isSelected) {
        int value = 1 << offset;
        this.selectValue = isSelected ? (this.selectValue |= (long)value) : (this.selectValue ^= (long)value);
        this.buttonList.get(offset).setSelection(isSelected);
        this.updateTitle();
    }

    public boolean isBitSelect(int bitOffset) {
        return (this.selectValue & (long)(1 << bitOffset)) > 0L;
    }

    public long getValue() {
        return this.selectValue;
    }

    public void setValue(long value) {
        this.selectValue = value;
        for (int i = 0; i < this.bytesCount * 8; ++i) {
            if ((this.selectValue & (long)(1 << i)) != 0L) {
                this.buttonList.get(i).setSelection(true);
                continue;
            }
            this.buttonList.get(i).setSelection(false);
        }
        if (this.isShowCheckBox) {
            if (this.selectValue == -1L && !this.btnChkTitle.getSelection()) {
                this.btnChkTitle.setSelection(true);
            } else if (this.selectValue != -1L && this.btnChkTitle.getSelection()) {
                this.btnChkTitle.setSelection(false);
            }
        }
        this.updateTitle();
        this.fireModifyListener();
    }
}

