/*
 * Decompiled with CFR 0.152.
 */
package manager.configure;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import manager.configure.Firmware;
import manager.configure.InstalledFirmwares;
import manager.configure.Platform;
import manager.utils.ManagerConfigs;
import manager.utils.ManagerFileUtils;

@XmlRootElement(name="ISSFirmwareConfiguration")
public class ISSFirmwareConfiguration {
    @XmlAttribute
    private String version = "unKnonwn";
    @XmlElement(name="platform")
    private List<InstalledFirmwares> installedFirmwares = new ArrayList<InstalledFirmwares>();
    public static final String CONFIG_FILL_NAME = "firmware.xml";
    public static final String BAK_FILL_NAME = ".firmware_bak.xml";
    private static ISSFirmwareConfiguration sConfig;

    public static String getConfigFile() throws Exception {
        String folder = ManagerFileUtils.FDK_ECLIPSE_CONFIG_FOLDER();
        return String.valueOf(folder) + File.separator + CONFIG_FILL_NAME;
    }

    public static String getConfigFile(String configfilepath) throws Exception {
        String folder = configfilepath;
        return String.valueOf(folder) + File.separator + CONFIG_FILL_NAME;
    }

    public static String getBakFile() throws Exception {
        String folder = ManagerFileUtils.FDK_ECLIPSE_CONFIG_FOLDER();
        return String.valueOf(folder) + File.separator + BAK_FILL_NAME;
    }

    public InstalledFirmwares getInstalledFwByPlatformName(String platName) {
        for (InstalledFirmwares firmwares : this.installedFirmwares) {
            if (!firmwares.getPlatformName().equals(platName)) continue;
            return firmwares;
        }
        return null;
    }

    public List<Firmware> getFirmwares(String name) {
        InstalledFirmwares ifs = this.getInstalledFwByPlatformName(name);
        if (ifs != null) {
            return ifs.getFirmwares();
        }
        return null;
    }

    public List<String> getFirmwareVersions(String platName) {
        ArrayList<String> versions = new ArrayList<String>();
        InstalledFirmwares ifs = this.getInstalledFwByPlatformName(platName);
        if (ifs != null) {
            for (Firmware fm : ifs.getFirmwares()) {
                versions.add(fm.getVersion());
            }
            return versions;
        }
        return versions;
    }

    public List<Firmware> getNoFDKFirmwares(Platform plat) {
        InstalledFirmwares ifs = this.getInstalledFwByPlatformName(plat.getName());
        if (ifs != null) {
            return ifs.getNoFDKFirmwares();
        }
        return null;
    }

    public Firmware getFirmwareByVersion(Platform plat, String version) {
        InstalledFirmwares ifs = this.getInstalledFwByPlatformName(plat.getName());
        if (ifs != null) {
            return ifs.getFirmwareByVersion(version);
        }
        return null;
    }

    public Firmware getDefaultFirmwareVersion(Platform plat) {
        InstalledFirmwares ifs = this.getInstalledFwByPlatformName(plat.getName());
        if (ifs != null) {
            return ifs.getDefaultFirmware();
        }
        return null;
    }

    public boolean isFirmwareInstalled(Platform plat, String ver) {
        ArrayList fms = (ArrayList)ManagerConfigs.getFirmwares(plat);
        if (fms == null) {
            return false;
        }
        for (Firmware fm : fms) {
            if (!fm.getVersion().equals(ver)) continue;
            return true;
        }
        return false;
    }

    public void setDefaultFirmwareVersion(String version, Platform plat) throws Exception {
        InstalledFirmwares ifs = this.getInstalledFwByPlatformName(plat.getName());
        if (ifs == null) {
            throw new Exception("Invalid platform");
        }
        ifs.setDefaultFwVersion(version);
        this.updateConfigs();
    }

    public void removeFirmware(Platform plat, Firmware fm) throws Exception {
        for (InstalledFirmwares fms : this.installedFirmwares) {
            if (!fms.getPlatformName().equals(plat.getName())) continue;
            int i = 0;
            while (i < fms.getFirmwares().size()) {
                Firmware f = fms.getFirmwares().get(i);
                if (f.equals(fm)) {
                    fms.getFirmwares().remove(i);
                }
                ++i;
            }
        }
        this.updateConfigs();
    }

    public void removeAllNoFDKFirmwares(Platform plat) throws Exception {
        InstalledFirmwares ifs = this.getInstalledFwByPlatformName(plat.getName());
        if (ifs == null) {
            throw new Exception("Invalid platform");
        }
        Iterator<Firmware> it = ifs.getFirmwares().iterator();
        while (it.hasNext()) {
            Firmware fw = it.next();
            if (fw.isFDKInstalled()) continue;
            it.remove();
        }
        this.updateConfigs();
    }

    public void removeAllFirmwares(Platform plat) throws Exception {
        int i = 0;
        while (i < this.installedFirmwares.size()) {
            InstalledFirmwares fms = this.installedFirmwares.get(i);
            if (fms.getPlatformName().equals(plat.getName())) {
                fms.getFirmwares().clear();
                this.installedFirmwares.remove(i);
            }
            ++i;
        }
        this.updateConfigs();
    }

    public void addFirmware(Platform plat, Firmware fm) throws Exception {
        boolean success = false;
        int i = 0;
        while (i < this.installedFirmwares.size()) {
            InstalledFirmwares fms = this.installedFirmwares.get(i);
            if (fms.getPlatformName().equals(plat.getName())) {
                fms.getFirmwares().add(fm);
                success = true;
            }
            ++i;
        }
        if (!success) {
            InstalledFirmwares addFms = new InstalledFirmwares(plat.getName());
            addFms.getFirmwares().add(fm);
            this.installedFirmwares.add(addFms);
            this.dump();
        }
        this.updateConfigs();
    }

    public void addFirmwares(List<Firmware> firmwares) throws Exception {
        for (Firmware fm : firmwares) {
            String pName = fm.getPlatform().getName();
            InstalledFirmwares ifs = this.getInstalledFwByPlatformName(pName);
            if (ifs == null) {
                ifs = new InstalledFirmwares(pName);
                this.installedFirmwares.add(ifs);
            }
            ifs.getFirmwares().add(fm);
        }
        this.updateConfigs();
    }

    public void updateConfigs() throws Exception {
        File cfg = new File(ISSFirmwareConfiguration.getConfigFile());
        File bak = new File(ISSFirmwareConfiguration.getBakFile());
        ManagerFileUtils.copyFile(cfg, bak);
        try {
            try {
                JAXBContext jc = JAXBContext.newInstance(ISSFirmwareConfiguration.class, InstalledFirmwares.class, Firmware.class);
                Marshaller marshalller = jc.createMarshaller();
                marshalller.setProperty("jaxb.formatted.output", true);
                marshalller.marshal((Object)this, cfg);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.rollback(cfg, bak);
                throw e;
            }
        }
        finally {
            if (bak != null && bak.exists()) {
                bak.delete();
            }
        }
    }

    private void rollback(File cfg, File bak) throws Exception {
        try {
            ManagerFileUtils.copyFile(bak, cfg);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        sConfig = null;
        ISSFirmwareConfiguration.getInstance();
    }

    public static ISSFirmwareConfiguration getInstance() throws Exception {
        if (sConfig == null) {
            ISSFirmwareConfiguration.init(ISSFirmwareConfiguration.getConfigFile());
        }
        return sConfig;
    }

    public static ISSFirmwareConfiguration getInstance(String configfilepath) throws Exception {
        if (configfilepath != null && !configfilepath.isEmpty()) {
            ISSFirmwareConfiguration.init(ISSFirmwareConfiguration.getConfigFile(configfilepath));
        }
        return sConfig;
    }

    private static void init(String configfilepath) throws Exception {
        try (FileInputStream xmlInput = null;){
            try {
                JAXBContext jc = JAXBContext.newInstance(ISSFirmwareConfiguration.class, InstalledFirmwares.class, Firmware.class);
                xmlInput = new FileInputStream(configfilepath);
                sConfig = (ISSFirmwareConfiguration)jc.createUnmarshaller().unmarshal(xmlInput);
                for (InstalledFirmwares ifs : ISSFirmwareConfiguration.sConfig.installedFirmwares) {
                    ifs.updateFirmware();
                }
            }
            catch (Exception fe) {
                throw new Exception("firmware.xml not existed or parse error");
            }
        }
    }

    public String dump() {
        String s = "*** start of firmware configuration ***\n";
        s = String.valueOf(s) + "version=" + this.version + "\n";
        for (InstalledFirmwares firmwares : this.installedFirmwares) {
            s = String.valueOf(s) + firmwares.dump();
        }
        s = String.valueOf(s) + "*** end of firmware configuration ***\n";
        return s;
    }
}

