/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.PlatformIdTable;
import pdtEditor.gui.DeviceProperties;
import pdtEditor.gui.GuiUtils;

public class PlatformId {
    protected Shell shlPlatformId;
    GuiUtils.WindowProperties _properties = new GuiUtils.WindowProperties(){

        @Override
        protected void onModification() {
        }
    };
    private Display display;
    private Text txtPlatformId;
    private Button btnCbxEnablePlatformId;

    public void saveData() {
        PlatformIdTable platformIdTable = DataStore.getInstance().getCurrentPdtFile().getPlatformIdTable();
        boolean newPlatformIdTable = false;
        if (platformIdTable == null) {
            platformIdTable = new PlatformIdTable();
            newPlatformIdTable = true;
        }
        platformIdTable.setEnablePlatformId(this.btnCbxEnablePlatformId.getSelection());
        if (newPlatformIdTable) {
            DataStore.getInstance().getCurrentPdtFile().addBdtObject(platformIdTable);
        }
        this._properties.setModified(false);
        this.shlPlatformId.close();
    }

    public void fillData() {
        PlatformIdTable platformIdTable = DataStore.getInstance().getCurrentPdtFile().getPlatformIdTable();
        if (platformIdTable == null) {
            platformIdTable = new PlatformIdTable();
        }
        this.btnCbxEnablePlatformId.setSelection(platformIdTable.isEnablePlatformId());
        this.txtPlatformId.setText(platformIdTable.getCurrentPlatformIdString());
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlPlatformId.open();
        this.shlPlatformId.layout();
        while (!this.shlPlatformId.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    protected void createContents() {
        this.shlPlatformId = new Shell(65632);
        this.shlPlatformId.setImage(SWTResourceManager.getImage(DeviceProperties.class, "/resources/Intel.ico"));
        this.shlPlatformId.setText("Platform Id");
        this.shlPlatformId.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (PlatformId.this._properties.isModified()) {
                    MessageBox messageBox = new MessageBox(PlatformId.this.shlPlatformId, 296);
                    messageBox.setText("Closing without saving");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the window without saving?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        GuiUtils.setGridLayoutToComposite((Composite)this.shlPlatformId, 1);
        Group grpPlatform = GuiUtils.addGroupToComposite("", (Composite)this.shlPlatformId, 0, 4, 4, true, true, 1, 1, 2);
        this.btnCbxEnablePlatformId = GuiUtils.addButtonToComposite("Enable Platform Id", "", (Composite)grpPlatform, 32, 16384, 0x1000000, false, false, 2, 1);
        GuiUtils.addLabelToComposite("Platform Id:", (Composite)grpPlatform, 0, 16384, 0x1000000, false, false, 1, 1);
        this.txtPlatformId = GuiUtils.addTextToComposite((Composite)grpPlatform, 2056, 4, 0x1000000, true, false, 1, 1);
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shlPlatformId, 0, 131072, 0x1000000, false, false, 1, 1, 2);
        Button buttonSaveAndClose = GuiUtils.addButtonToComposite("Save and Close", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Button buttonCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        buttonSaveAndClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PlatformId.this.saveData();
            }
        });
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PlatformId.this.shlPlatformId.close();
            }
        });
        this.btnCbxEnablePlatformId.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean isEnabled = PlatformId.this.btnCbxEnablePlatformId.getSelection();
                PlatformIdTable platformIdTable = new PlatformIdTable();
                PlatformId.this.txtPlatformId.setText(platformIdTable.getPlatformIdString(isEnabled));
                PlatformId.this._properties.setModified(true);
            }
        });
        int longButtonMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlPlatformId) * 1.5);
        int shortButtonMinWidth = GuiUtils.getButtonWidth((Control)this.shlPlatformId);
        ((GridData)this.btnCbxEnablePlatformId.getLayoutData()).minimumWidth = longButtonMinWidth;
        ((GridData)buttonSaveAndClose.getLayoutData()).minimumWidth = longButtonMinWidth;
        ((GridData)buttonCancel.getLayoutData()).minimumWidth = shortButtonMinWidth;
        this.shlPlatformId.setSize(this.shlPlatformId.computeSize(-1, -1));
        this.shlPlatformId.setLocation(GuiUtils.getMiddleLocation(this.shlPlatformId, this.display));
    }
}

