<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>configure - Configure l'arborescence des sources - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Programmes</a></div><div id="page-content"><div id="preamble"><h1>configure - Configure l'arborescence des sources</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/programs/configure.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/programs/configure.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/programs/configure.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/programs/configure.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

    <p>Le script <code>configure</code> permet de configurer
    l'arborescence des sources afin de compiler et installer le serveur
    HTTP Apache sur votre plate-forme spcifique. De nombreuses options
    vous permettent de compiler un serveur correspondant  vos propres
    besoins.</p>

    <p>Ce script, situ dans le rpertoire racine de la distribution des
    sources, ne concerne que la compilation sur les systmes Unix et
    apparents. Pour les autres plates-formes, voir la <a href="../platform/">documentation spcifique</a> de ces
    dernires.</p>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#synopsis">Rsum</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#options">Options</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#env">Variables d'environnement</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="../install.html">Compilation et installation</a></li><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="synopsis" id="synopsis">Rsum</a></h2>
    <p>Vous devez appeler le script <code>configure</code> depuis le
    rpertoire racine de la distribution.</p>

    <p><code><strong>./configure</strong> [<var>OPTION</var>]...
    [<var>VARIABLE</var>=<var>VALEUR</var>]...</code></p>

    <p>Pour dfinir des variables d'environnement (par exemple
    <code>CC</code>,<code>CFLAGS</code>, etc...), utilisez la clause
    <code><var>VARIABLE</var>=<var>VALEUR</var></code>. Voir <a href="#env">ci-dessous</a> pour la description de quelques variables
    usuelles.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="options" id="options">Options</a></h2>
  <ul>
    <li><a href="#configurationoptions">Options de Configuration</a></li>
    <li><a href="#installationdirectories">Rpertoires d'installation</a></li>
    <li><a href="#systemtypes">Types de Systmes</a></li>
    <li><a href="#optionalfeatures">Fonctionnalits optionnelles</a></li>
    <li><a href="#supportopt">Options pour les programmes support</a></li>
  </ul>

  <h3><a name="configurationoptions" id="configurationoptions">Options de Configuration</a></h3>

    <p>Les options suivantes affectent le comportement du script
    <code>configure</code>.</p>

    <dl>
      <dt><code>-C</code></dt>
      <dt><code>--config-cache</code></dt>
      <dd>C'est un alias pour <code>--cache-file=config.cache</code></dd>

      <dt><code>--cache-file=<var>FICHIER</var></code></dt>
      <dd>Les rsultats des tests seront mis en cache dans le fichier
      <var>FICHIER</var>. Cette option est dsactive par dfaut.</dd>

      <dt><code>-h</code></dt>
      <dt><code>--help [short|recursive]</code></dt>
      <dd>Affichage de l'aide et sortie du script. Avec l'argument
      <code>short</code>, seules les options spcifiques  ce paquet
      seront affiches. L'argument <code>recursive</code> permet
      d'afficher l'aide de tous les paquets inclus.</dd>

      <dt><code>-n</code></dt>
      <dt><code>--no-create</code></dt>
      <dd>Le script <code>configure</code> s'excute normalement, mais
      ne cre pas les fichiers rsultants. Ceci permet de vrifier les
      rsultats des tests avant de gnrer les fichiers makefile pour la
      compilation.</dd>

      <dt><code>-q</code></dt>
      <dt><code>--quiet</code></dt>
      <dd>Les messages <code>checking ...</code> ne sont pas affichs au
      cours du processus de configuration.</dd>

      <dt><code>--srcdir=<var>DIR</var></code></dt>
      <dd>Dfinit le rpertoire <var>DIR</var> comme rpertoire des
      fichiers sources. Par dfaut, c'est le rpertoire o se situe le
      script <code>configure</code>, ou le rpertoire parent.</dd>

      <dt><code>--silent</code></dt>
      <dd>Identique  <code>--quiet</code></dd>

      <dt>-V</dt>
      <dt>--version</dt>
      <dd>Affichage des informations de copyright et sortie du
      script.</dd>
    </dl>
  

  <h3><a name="installationdirectories" id="installationdirectories">Rpertoires
  d'installation</a></h3>

    <p>Ces options permettent de spcifier le rpertoire d'installation.
    L'arborescence de l'installation dpend de l'organisation (layout)
    slectionne.</p>

    <dl>
      <dt><code>--prefix=<var>PREFIX</var></code></dt>
      <dd>Installe les fichiers indpendants de l'architecture dans
      <var>PREFIX</var>. Par dfaut, le rpertoire d'installation est
      <code>/usr/local/apache2</code>.</dd>

      <dt><code>--exec-prefix=<var>EPREFIX</var></code></dt>
      <dd>Installe les fichiers dpendants de l'architecture dans
      <var>EPREFIX</var>. La valeur par dfaut de cette option
      correspond  la valeur de la variable
      <var>PREFIX</var>.</dd>
    </dl>

    <p>Par dfaut, <code>make install</code> va installer tous les
    fichiers dans <code>/usr/local/apache2/bin</code>,
    <code>/usr/local/apache2/lib</code>, etc... Vous pouvez cependant
    spcifier un prfixe d'installation autre que
    <code>/usr/local/apache2</code> en utilisant l'option
    <code>--prefix</code> (par exemple <code>--prefix=$HOME</code>).</p>

    <h4><a name="layout" id="layout">Spcifier une organisation (layout) des
    rpertoires</a></h4>
      <dl>
        <dt><code>--enable-layout=<var>LAYOUT</var></code></dt>
        <dd>Configure le code source et les scripts de compilation de
	faon  ce que l'arborescence d'installation adopte
	l'organisation <var>LAYOUT</var>. Ceci vous permet de spcifier
	des chemins spars pour chaque type de fichier de
	l'installation du serveur HTTP Apache. Le fichier
	<code>config.layout</code> contient de nombreux exemples de
	configurations, et vous pouvez crer vos propres configurations
	personnalises en vous basant sur ces exemples. Les diffrentes
	organisations contenues dans ce fichier sont enregistres sous
	forme de sections <code>&lt;Layout
	FOO&gt;...&lt;/Layout&gt;</code> et rfrences dans ce cas par
	le nom <code>FOO</code>. L'organisation par dfaut
	est <code>Apache</code>.</dd>
      </dl>
    

    <h4><a name="directoryfinetuning" id="directoryfinetuning">Configuration avance des
    rpertoires d'installation</a></h4>

      <p>Pour une dfinition plus prcise des rpertoires
      d'installation, utilisez les options ci-dessous. Notez que les
      rpertoires par dfaut sont dfinis par <code>autoconf</code>, et
      que leurs valeurs sont crases par les valeurs correspondantes
      dfinies lors du choix de l'organisation des rpertoires
      (layout).</p>

      <dl>
        <dt><code>--bindir=<var>DIR</var></code></dt>
        <dd>Installe les excutables utilisateur dans <var>DIR</var>.
	Les excutables utilisateur sont des programmes support comme
	<code class="program"><a href="../programs/htpasswd.html">htpasswd</a></code>, <code class="program"><a href="../programs/dbmmanage.html">dbmmanage</a></code>,
	etc..., et destins aux administrateurs du site. Par dfaut,
	<var>DIR</var> est dfini 
	<code><var>EPREFIX</var>/bin</code>.</dd>

        <dt><code>--datadir=<var>DIR</var></code></dt>
        <dd>Installe les donnes non modifiables indpendantes de
	l'architecture dans <var>DIR</var>. Par dfaut,
	<code>datadir</code> est dfini 
	<code><var>PREFIX</var>/share</code>. Cette option est fournie
	par autoconf et actuellement inutilise.</dd>

        <dt><code>--includedir=<var>DIR</var></code></dt>
        <dd>Installe les fichiers d'en-ttes C dans <var>DIR</var>. Par
	dfaut, <code>includedir</code> est dfini 
	<code><var>EPREFIX</var>/include</code>.</dd>

        <dt><code>--infodir=<var>DIR</var></code></dt>
        <dd>Installe la documentation info dans <var>DIR</var>. Par
	dfaut, <code>infodir</code> est dfini 
	<code><var>PREFIX</var>/info</code>. Cette option est
	actuellement inutilise.</dd>

        <dt><code>--libdir=<var>DIR</var></code></dt>
        <dd>Installe les fichiers objet des bibliothques dans
	<var>DIR</var>. Par dfaut, <code>libdir</code> est dfini 
	<code><var>EPREFIX</var>/lib</code>.</dd>

        <dt><code>--libexecdir=<var>DIR</var></code></dt>
        <dd>Installe les excutables du programme (autrement dit les
	modules partags) dans <var>DIR</var>. Par dfaut,
	<code>libexecdir</code> est dfini 
	<code><var>EPREFIX</var>/modules</code>.</dd>

        <dt><code>--localstatedir=<var>DIR</var></code></dt>
        <dd>Installe les donnes temporaires modifiables spcifiques 
	la machine dans
	<var>DIR</var>. Par dfaut, <code>localstatedir</code> est
	dfini  <code><var>PREFIX</var>/var</code>. Cette option est
	fournie par <code>autoconf</code> et est actuellement
	inutilise.</dd>

        <dt><code>--mandir=<var>DIR</var></code></dt>
        <dd>Installe les pages de manuel dans  <var>DIR</var>. Par
	dfaut, <code>mandir</code> est dfini 
	<code><var>EPREFIX</var>/man</code>.</dd>

        <dt><code>--oldincludedir=<var>DIR</var></code></dt>
        <dd>Installe les fichiers d'en-ttes C pour les programmes
	autres que gcc dans <var>DIR</var>. Par dfaut,
	<code>oldincludedir</code> est dfini 
	<code>/usr/include</code>. Cette option est fournie par
	<code>autoconf</code> et est actuellement inutilise.</dd>

        <dt><code>--sbindir=<var>DIR</var></code></dt>
        <dd>Installe les excutables de l'administrateur systme dans
	<var>DIR</var>. Ce sont les programmes du serveur comme
	<code class="program"><a href="../programs/httpd.html">httpd</a></code>, <code class="program"><a href="../programs/apachectl.html">apachectl</a></code>,
	<code class="program"><a href="../programs/suexec.html">suexec</a></code>, etc..., qui sont ncessaires 
	l'excution du serveur HTTP Apache. Par dfaut,
	<code>sbindir</code> est dfini 
	<code><var>EPREFIX</var>/sbin</code>.</dd>

        <dt><code>--sharedstatedir=<var>DIR</var></code></dt>
        <dd>Installe les donnes modifiables indpendantes de
	l'architecture dans <var>DIR</var>. Par dfaut,
	<code>sharedstatedir</code> est dfini 
	<code><var>PREFIX</var>/com</code>. Cette option est fournie par
	<code>autoconf</code> et est actuellement inutilise.</dd>

        <dt><code>--sysconfdir=<var>DIR</var></code></dt>
        <dd>Installe les donnes non modifiables spcifiques  la
	machine comme les fichiers de configuration du serveur
	<code>httpd.conf</code>, <code>mime.types</code>, etc... dans
	<var>DIR</var>. Par dfaut, <code>sysconfdir</code> est dfini 
	<code><var>PREFIX</var>/conf</code>.</dd>
      </dl>
    
  

  <h3><a name="systemtypes" id="systemtypes">Types de systmes</a></h3>

    <p>Ces options sont utilises pour la cross-compilation du serveur
    HTTP Apache afin de pouvoir l'utiliser sur un autre systme. Dans le
    cas gnral o la compilation et l'excution du serveur ont lieu sur
    le mme systme, ces options ne sont pas utilises.</p>

    <dl>
      <dt><code>--build=<var>BUILD</var></code></dt>
      <dd>Dfinit le type du systme sur lequel les outils sont
      compils. Par dfaut, il s'agit de la chane renvoye par le
      script <code>config.guess</code>.</dd>

      <dt><code>--host=<var>HOST</var></code></dt>
      <dd>Dfinit le type du systme sur lequel le serveur s'excutera.
      Par dfaut, <var>HOST</var> est identique  <var>BUILD</var>.</dd>

      <dt><code>--target=<var>TARGET</var></code></dt>
      <dd>Configure pour construire des compilateurs pour le type de
      systme <var>TARGET</var>. Par dfaut, <var>TARGET</var> est
      identique  <var>HOST</var>. Cette option est fournie par
	<code>autoconf</code> et n'est pas requise par le serveur HTTP
	Apache.</dd>
    </dl>
  

  <h3><a name="optionalfeatures" id="optionalfeatures">Fonctionnalits
  optionnelles</a></h3>

    <p>Ces options vous permettent de configurer avec prcision les
    fonctionnalits de votre futur serveur HTTP.</p>

    <h4><a name="generaloptfeat" id="generaloptfeat">Syntaxe gnrale</a></h4>
      <p>D'une manire gnrale, vous pouvez utiliser la syntaxe
      suivante pour activer ou dsactiver une fonctionnalit :</p>

      <dl>
        <dt><code>--disable-<var>FONCTIONNALITE</var></code></dt>
        <dd>Dsactive la fonctionnalit <var>FONCTIONNALITE</var>.
	Identique 
	<code>--enable-<var>FONCTIONNALITE</var>=no</code>.</dd>

        <dt><code>--enable-<var>FONCTIONNALITE</var>[=<var>ARG</var>]</code></dt>
        <dd>Active la fonctionnalit <var>FONCTIONNALITE</var>. La
	valeur par dfaut de <var>ARG</var> est <code>yes</code>.</dd>

        <dt><code>--enable-<var>MODULE</var>=shared</code></dt>
        <dd>Le module spcifi sera compil en tant que module DSO. Par
	dfaut, les modules activs sont lis dynamiquement.</dd>

        <dt><code>--enable-<var>MODULE</var>=static</code></dt>
        <dd>Le module correspondant sera li statiquement.</dd>
      </dl>

      <div class="note"><h3>Note</h3>
        Si vous spcifiez <code>--enable-<var>foo</var></code>, et si
	<var>foo</var> n'existe pas, <code>configure</code> ne le
	signalera pas ; vous devez donc prendre soin de taper les
	options correctement.
      </div>
    

    <h4><a name="choosemodules" id="choosemodules">Choix des modules  compiler</a></h4>
      <p>La plupart des modules sont compils par dfaut et ils doivent tre
      dsactivs de manire explicite ou via le mots-cl <code>few</code> (voir
      ci-dessous <code>--enable-modules</code>,
      <code>--enable-mods-shared</code> et <code>--enable-mods-static</code>
      pour une explication plus dtaille), ou
      <code>--enable-modules=none</code> pour les dsactiver tous.</p>

      <p>Par dfaut, les autres modules ne sont pas compils et doivent
      tre activs explicitement, ou en utilisant les mots-cls
      <code>all</code> ou <code>reallyall</code> pour tre disponibles.</p>

      <p>Pour dterminer quels modules sont compils par dfaut,
      excutez la commande <code>./configure -h</code> ou
      <code>./configure --help</code>, et consultez les <code>Optional
      Features</code>. Par exemple, supposons que vous soyez intress
      par les modules <code>mod_example1</code> et
      <code>mod_example2</code>, et que vous voyiez ceci :</p>

        <div class="example"><pre>Optional Features:
  ...
  --disable-example1     example module 1
  --enable-example2      example module 2
  ...</pre></div>

        <p>Le module <code>mod_example1</code> est ici activ par
	dfaut, et vous devez spcifier <code>--disable-example1</code>
	si vous ne voulez pas le compiler. Par contre, le module
	<code>mod_example2</code> est dsactiv par dfaut, et vous
	devez spcifier <code>--enable-example2</code> si vous voulez le
	compiler.</p>

    

    <h4><a name="mpms" id="mpms">Modules Multi-Processus</a></h4>
      <p>Les <a href="../mpm.html">Modules Multi-Processus</a>, ou MPMs,
      constituent le coeur du serveur. Un seul MPM doit tre actif pour
      que le serveur puisse fonctionner. Vous trouverez la liste des
      MPMs disponibles  <a href="../mod/">module index page</a>.</p>

      <p>Les MPMs peuvent tre compils en tant que modules DSO pour un
      chargement dynamique, ou lis statiquement avec le serveur, et
      sont activs via les options suivantes :</p>

      <dl>
        <dt><code>--with-mpm=MPM</code></dt>
        <dd>
          <p>Slectionne le MPM par dfaut pour votre serveur. Si les
	  MPMs sont compils en tant que modules DSO (voir
	  <code>--enable-mpms-shared</code>), cette option spcifie le
	  MPM qui sera charg par dfaut selon le fichier de
	  configuration. Dans le cas contraire, cette option spcifie le
	  seul MPM disponible qui sera li statiquement avec le
	  serveur.</p>
          <p>Si cette option est omise, c'est le <a href="../mpm.html#defaults">MPM par dfaut</a> pour votre
	  systme d'exploitation qui sera utilis.</p>
        </dd>

        <dt><code>--enable-mpms-shared=<var>Liste de MPM</var></code></dt>
        <dd>
          <p>Dfinit une liste de MPMs  compiler en tant que modules
	  dynamiquement partags (DSO). Un de ces modules doit tre
	  charg dynamiquement via la directive <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code>.</p>
          <p><var>Liste de MPM</var> est une liste, entoure
	  d'apostrophes,  de noms de MPM spars par des espaces. Par
	  exemple :</p>
          <div class="example"><p><code>
            --enable-mpms-shared='prefork worker'
          </code></p></div>
          <p>Vous pouvez aussi utiliser le mot-cl <code>all</code>, ce
	  qui aura pour effet de spcifier tous les MPMs qui supportent
	  le chargement dynamique sur la plate-forme considre, et de
	  les compiler en tant que modules DSO. Par exemple :</p>
          <div class="example"><p><code>
            --enable-mpms-shared=all
          </code></p></div>
	</dd>
      </dl>
    

    <h4><a name="modules" id="modules">Modules tiers</a></h4>
      <p>Pour ajouter des modules tiers, utilisez les options suivantes
      :</p>

      <dl>
        <dt><code>--with-module=<var>type-module</var>:<var>fichier-module</var>[,
          <var>type-module</var>:<var>fichier-module</var>]</code></dt>
        <dd><p>Ajoute un ou plusieurs modules tiers  la liste des
	modules lis statiquement. Le fichier source du module
	<var>fichier-module</var> sera recherch dans le sous-rpertoire
	<var>type-module</var> de l'arborescence des sources de votre
	serveur HTTP Apache. S'il ne l'y trouve pas,
	<code>configure</code> considrera <var>fichier-module</var>
	comme un chemin de fichier absolu et essaiera de copier le
	fichier source dans le sous-rpertoire <var>type-module</var>.
	Si ce sous-rpertoire n'existe pas, il sera cr et un fichier
	<code>Makefile.in</code> standard y sera enregistr.</p>
          <p>Cette option est conue pour ajouter de petits modules
	  externes ne comportant qu'un seul fichier source. Pour des
	  modules plus complexes, vous devrez lire la documentation du
	  fournisseur du module.</p>
          <div class="note"><h3>Note</h3>
            Si vous voulez compiler un module DSO (li de manire
	    dynamique au lieu de statique), utilisez le programme
	    <code class="program"><a href="../programs/apxs.html">apxs</a></code>.</div>
        </dd>

      </dl>
    

    <h4><a name="otheroptfeat" id="otheroptfeat">Options cumulatives et autres
    options</a></h4>
      <dl>
        <dt><code>--enable-maintainer-mode</code></dt>
        <dd>Active les avertissements de dbogage et de compilation et
	charge tous les modules compils.</dd>

        <dt><code>--enable-mods-shared=<var>LISTE-MODULES</var></code></dt>
        <dd>
          <p>Dfinit une liste de modules  activer et  compiler en
	  tant que modules dynamiques partags. Cela signifie que ces
	  modules doivent tre chargs dynamiquement en utilisant la
	  directive <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code>.</p>
          <p><var>LISTE-MODULES</var> est une liste, entoure
	  d'apostrophes, de noms de modules
	  spars par des espaces. Les noms
	  des modules sont spcifis sans le prfixe <code>mod_</code>.
	  Par exemple :</p>
          <div class="example"><p><code>
            --enable-mods-shared='headers rewrite dav'
          </code></p></div>
          <p>Vous pouvez aussi utiliser les mots-cls <code>reallyall</code>,
	  <code>all</code>, <code>most</code> et <code>few</code>. Par
	  exemple,</p>
          <div class="example"><p><code>
            --enable-mods-shared=most
          </code></p></div>
          <p>va compiler la plupart des modules en tant que modules DSO,</p>
	  <div class="example"><p><code>
            --enable-mods-shared=few
          </code></p></div>
          <p>ne compilera qu'un jeu de modules de base.</p>
          <p>Le jeu par dfaut correspond au mot-cl <code>most</code>.</p>
            
	  <p>Les directives <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code> correspondant aux
	  diffrents modules choisis sont automatiquement gnres dans
	  le fichier de configuration principal. Par dfaut, toutes ces
	  directives sont mises en commentaire, sauf pour les modules
	  requis ou ceux explicitement slectionns par un argument
	  <code>--enable-nom-module</code> du script configure. Vous
	  pouvez modifier le jeu de modules charg en activant ou
	  dsactivant les directives <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code> dans le fichier
	  <code>httpd.conf</code>. En outre, les directives <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code> peuvent tre actives
	  pour tous les modules compils via l'option
	  <code>--enable-load-all-modules</code> du script configure.</p>
          
        </dd>

        <dt><code>--enable-mods-static=<var>MODULE-LIST</var></code></dt>
        <dd>Cette option produit le mme effet que l'option
	<code>--enable-mods-shared</code>,  l'exception que les modules
	seront lis statiquement. Cela signifie que les modules
	spcifis seront toujours disponibles au cours du fonctionnement
	de <code class="program"><a href="../programs/httpd.html">httpd</a></code>. Ils n'ont pas besoin d'tre chargs
	via la directive <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code>.</dd>

	<dt><code>--enable-modules=<var>MODULE-LIST</var></code></dt>
        <dd>Cette option se comporte comme
	<code>--enable-mods-shared</code>, et va aussi lier les modules
	concerns dynamiquement. Le mot-cl spcial <code>none</code>
	dsactive la compilation de tous les modules.</dd>

        <dt><code>--enable-v4-mapped</code></dt>
        <dd>Permet aux sockets IPv6 de traiter les connexions IPv4.</dd>

        <dt><code>--with-port=<var>PORT</var></code></dt>
        <dd>Permet de dfinir le port que le programme
	<code class="program"><a href="../programs/httpd.html">httpd</a></code> va couter. Ce numro de port est
	utilis lors de la gnration du fichier de configuration
	<code>httpd.conf</code>. Sa valeur par dfaut est 80.</dd>

        <dt><code>--with-program-name</code></dt>
        <dd>Permet de dfinir un nom d'excutable alternatif. Le nom par
	dfaut est <code>httpd</code>.</dd>
      </dl>
    
  

  <h3><a name="packages" id="packages">Paquets optionnels</a></h3>
    <p>Ces options permettent de dfinir des paquets optionnels.</p>

    <h4><a name="generalpackages" id="generalpackages">Syntaxe gnrale</a></h4>
      <p>D'une manire gnrale, vous pouvez utiliser la syntaxe
      suivante pour dfinir un paquet optionnel :</p>

      <dl>
        <dt><code>--with-<var>PAQUET</var>[=<var>ARG</var>]</code></dt>
        <dd>Utilise le paquet <var>PAQUET</var>. La valeur par dfaut de
	<var>ARG</var> est <code>yes</code>.</dd>

        <dt><code>--without-<var>PAQUET</var></code></dt>
        <dd>N'utilise pas le paquet <var>PAQUET</var>. Cette option est
	identique  <code>--with-<var>PAQUET</var>=no</code>. Elle est
	fournie par <code>autoconf</code> mais n'est pas trs utile pour
	le serveur HTTP Apache.</dd>
      </dl>
    

    

    <h4><a name="packageopt" id="packageopt">Paquets spcifiques</a></h4>
      <dl>
        <dt><code>--with-apr=<var>REP</var>|<var>FICHIER</var></code></dt>
        <dd>La <a class="glossarylink" href="../glossary.html#apr" title="voir glossaire">Bibliothque pour la portabilit
	d'Apache ou
	Apache Portable Runtime</a> (APR) fait partie de la
	distribution des sources de httpd et est compile
	automatiquement avec le serveur HTTP. Si vous voulez utiliser
	une APR dj installe  la place, vous devez indiquer 
	<code>configure</code> le chemin du script
	<code>apr-config</code>. Vous pouvez spcifier le chemin absolu
	et le nom ou le rpertoire d'installation de l'APR.
	<code>apr-config</code> doit se trouver dans ce rpertoire ou
	dans le sous-repertoire <code>bin</code>.</dd>

        <dt><code>--with-apr-util=<var>REP</var>|<var>FICHIER</var></code></dt>
        <dd>Les utilitaires pour la Bibliothque pour la portabilit
	d'Apache ou Apache Portable Runtime Utilities (APU) font partie de la
	distribution des sources de httpd et sont compils
	automatiquement avec le serveur HTTP. Si vous voulez utiliser
	des APU dj installs  la place, vous devez indiquer 
	<code>configure</code> le chemin du script
	<code>apu-config</code>. Vous pouvez spcifier le chemin absolu
	et le nom ou le rpertoire d'installation des APU.
	<code>apu-config</code> doit se trouver dans ce rpertoire ou
	dans le sous-repertoire <code>bin</code>.</dd>

        <dt><code>--with-ssl=<var>REP</var></code></dt>
        <dd>Si <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> a t activ,
	<code>configure</code> recherche une installation d'OpenSSL.
	Vous pouvez dfinir le rpertoire de la bote  outils SSL/TLS 
	la place.</dd>

        <dt><code>--with-z=<var>REP</var></code></dt>
        <dd><code>configure</code> recherche automatiquement une
	bibliothque <code>zlib</code> installe si la configuration de
	vos sources en ncessite une (par exemple lorsque
	<code class="module"><a href="../mod/mod_deflate.html">mod_deflate</a></code> est activ). Vous pouvez dfinir le
	rpertoire de la bibliothque de compression  la place.</dd>
      </dl>

      <p>De nombreuses fonctionnalits du serveur HTTP Apache, y compris
      les directives <code class="directive"><a href="../mod/mod_rewrite.html#rewritemap">RewriteMap</a></code> DBM de
      <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> et <code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code>
      utilisent une base de donnes simple
      de la forme cl/valeur pour une recherche rapide d'informations.
      SDBM, inclus dans les APU, est donc toujours disponible. Si vous
      souhaitez utiliser d'autres types de bases de donnes, utilisez
      les options suivantes afin de les activer :</p>

      <dl>
        <dt><code>--with-gdbm[=<var>chemin</var>]</code></dt>
        <dd>Si aucun <var>chemin</var> n'est spcifi,
	<code>configure</code> va rechercher les fichiers d'en-ttes et
	les bibliothques d'une installation DBM GNU dans les chemins
	standards. Avec un <var>chemin</var> explicite,
	<code>configure</code> recherchera les fichiers concerns dans
	<code><var>chemin</var>/lib</code> et
	<code><var>chemin</var>/include</code>. En fait,
	<var>chemin</var> permet de spcifier plusieurs chemins
	d'en-ttes et bibliothques spcifiques en les sparant par des
	caractres ':'.</dd>

        <dt><code>--with-ndbm[=<var>chemin</var>]</code></dt>
        <dd>Identique  <code>--with-gdbm</code>, mais recherche une
	installation de New DBM.</dd>

        <dt><code>--with-berkeley-db[=<var>chemin</var>]</code></dt>
        <dd>Identique  <code>--with-gdbm</code>, mais recherche une
	installation de Berkeley DB.</dd>
      </dl>

      <div class="note"><h3>Note</h3>
        <p>Les options DBM sont fournies par les APU et passes en
	paramtres  son script de configuration. Elles sont inutiles
	lorsqu'on utilise des APU dj installs dfinis par
	<code>--with-apr-util</code>.</p>
        <p>Vous pouvez utiliser plusieurs implmentations DBM avec votre
	serveur HTTP. Le type DBM appropri sera choisi au cours de la
	configuration de l'excution  chaque dmarrage.</p>
      </div>
    
  

  <h3><a name="supportopt" id="supportopt">Options pour les programmes de
  support</a></h3>
    <dl>
      <dt><code>--enable-static-support</code></dt>
      <dd>Permet de compiler une version des binaires de support lis
      statiquement. En d'autres termes, la compilation produira un
      excutable indpendant comportant toutes les bibliothques
      ncessaires. Sans cette option, les binaires de supports sont lis
      dynamiquement.</dd>

      <dt><code>--enable-suexec</code></dt>
      <dd>Utilisez cette option pour activer la programme
      <code class="program"><a href="../programs/suexec.html">suexec</a></code>, qui vous permet de dfinir un uid et un
      gid pour les processus lancs. <strong>N'utilisez cette option que
      si vous matrisez toutes les implications en matire de scurit
      de l'excution d'un binaire suid sur votre serveur.</strong>
      D'autres options permettent de configurer
      <code class="program"><a href="../programs/suexec.html">suexec</a></code> comme dcrit <a href="#suexec">ci-dessous</a>.</dd>
    </dl>

    <p>Il est possible de lier statiquement le binaire d'un programme
    support particulier en utilisant les options suivantes :</p>

    <dl>
      <dt><code>--enable-static-ab</code></dt>
      <dd>Compile une version lie statiquement du programme
      <code class="program"><a href="../programs/ab.html">ab</a></code>.</dd>

      
      <dt><code>--enable-static-checkgid</code></dt>
      <dd>&gt;Compile une version lie statiquement du programme
      <code>checkgid</code>.</dd>

      <dt><code>--enable-static-htdbm</code></dt>
      <dd>Compile une version lie statiquement du programme <code class="program"><a href="../programs/htdbm.html">htdbm</a></code>.</dd>

      <dt><code>--enable-static-htdigest</code></dt>
      <dd>Compile une version lie statiquement du programme <code class="program"><a href="../programs/htdigest.html">htdigest</a></code>.</dd>

      <dt><code>--enable-static-htpasswd</code></dt>
      <dd>Compile une version lie statiquement du programme <code class="program"><a href="../programs/htpasswd.html">htpasswd</a></code>.</dd>

      <dt><code>--enable-static-logresolve</code></dt>
      <dd>Compile une version lie statiquement du programme <code class="program"><a href="../programs/logresolve.html">logresolve</a></code>.</dd>

      <dt><code>--enable-static-rotatelogs</code></dt>
      <dd>Compile une version lie statiquement du programme <code class="program"><a href="../programs/rotatelogs.html">rotatelogs</a></code>.</dd>
    </dl>

    <h4><a name="suexec" id="suexec">Options de configuration de <code>suexec</code></a></h4>
      
      <p>Les options suivantes permettent de dfinir avec prcision le
      comportement du programme <code class="program"><a href="../programs/suexec.html">suexec</a></code>. Voir <a href="suexec.html#install">Configurer et installer suEXEC</a>
	pour plus de dtails.</p>

      <dl>
        <dt><code>--with-suexec-bin</code></dt>
        <dd>Dfinit le chemin du binaire <code class="program"><a href="../programs/suexec.html">suexec</a></code>. La
	valeur par dfaut est <code>--sbindir</code> (voir <a href="#directoryfinetuning">Dfinition prcise des rpertoires
	d'installation</a>).</dd>

        <dt><code>--with-suexec-caller</code></dt>
        <dd>Dfinit l'utilisateur qui a l'autorisation d'appeler
	<code class="program"><a href="../programs/suexec.html">suexec</a></code>. Il est en gnral souhaitable que ce
	soit le mme que celui sous lequel <code class="program"><a href="../programs/httpd.html">httpd</a></code>
	s'excute.</dd>

        <dt><code>--with-suexec-docroot</code></dt>
        <dd>Dfinit l'arborescence des rpertoires dans laquelle le
	lancement des excutables via <code class="program"><a href="../programs/suexec.html">suexec</a></code> est
	autoris. La valeur par dfaut est
	<code>--datadir/htdocs</code>.</dd>

        <dt><code>--with-suexec-gidmin</code></dt>
        <dd>Dfinit la valeur de GID la plus basse autorise comme
	valeur cible pour <code class="program"><a href="../programs/suexec.html">suexec</a></code>. La valeur par
	dfaut est 100.</dd>

        <dt><code>--with-suexec-logfile</code></dt>
        <dd>Dfinit le nom du fichier journal de
	<code class="program"><a href="../programs/suexec.html">suexec</a></code>. La valeur par dfaut est
	<code>--logfiledir/suexec_log</code>.</dd>

        <dt><code>--with-suexec-safepath</code></dt>
        <dd>Dfinit la valeur de la variable d'environnement
	<code>PATH</code> pour les processus lancs par
	<code class="program"><a href="../programs/suexec.html">suexec</a></code>. La valeur par dfaut est
	<code>/usr/local/bin:/usr/bin:/bin</code>.</dd>

        <dt><code>--with-suexec-userdir</code></dt>
        <dd>Dfinit le sous-rpertoire du rpertoire utilisateur qui
	contient tous les excutables pouvant tre lancs par
	<code class="program"><a href="../programs/suexec.html">suexec</a></code>. Cette option est ncessaire si vous
	souhaitez utiliser <code class="program"><a href="../programs/suexec.html">suexec</a></code> avec des
	rpertoires utilisateurs (dfinis via
	<code class="module"><a href="../mod/mod_userdir.html">mod_userdir</a></code>). La valeur par dfaut est
	<code>public_html</code>.</dd>

        <dt><code>--with-suexec-uidmin</code></dt>
        <dd>Dfinit la valeur d'UID la plus basse autorise comme
	valeur cible pour <code class="program"><a href="../programs/suexec.html">suexec</a></code>. La valeur par
	dfaut est 100.</dd>

        <dt><code>--with-suexec-umask</code></dt>
        <dd>Dfinit le masque de permissions <code>umask</code> pour les
	processus lancs par <code class="program"><a href="../programs/suexec.html">suexec</a></code>. Il correspond
	par dfaut au masque dfini par la configuration de votre
	systme.</dd>
      </dl>
    
  
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="env" id="env">Variables d'environnement</a></h2>
  <p>Certaines variables d'environnement permettent de modifier les
  choix effectus par <code>configure</code>, ou d'aider ce dernier 
  trouver les bibliothques et programmes possdant des noms et chemins
  non standards.</p>

  
  <dl>
    <dt><code>CC</code></dt>
    <dd>Dfinit la commande du compilateur C  utiliser pour la
    compilation.</dd>

    <dt><code>CFLAGS</code></dt>
    <dd>Dfinit les paramtres du compilateur C que vous voulez utiliser
    pour la compilation.</dd>

    <dt><code>CPP</code></dt>
    <dd>Dfinit la commande du prprocesseur C  utiliser.</dd>

    <dt><code>CPPFLAGS</code></dt>
    <dd>Dfinit les paramtres du prprocesseur C/C++, par exemple
    <code>-I<var>rpertoire-include</var></code>, si certains de vos
    fichiers d'en-ttes se trouvent dans le rpertoire non standard
    <var>rpertoire-include</var>.</dd>

    <dt><code>LDFLAGS</code></dt>
    <dd>Dfinit les paramtres de l'diteur de liens, par exemple
    <code>-L<var>rpertoire-lib</var></code>, si certaines de vos
    bibliothques se trouvent dans le rpertoire non standard
    <var>rpertoire-lib</var>.</dd>
  </dl>
</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/programs/configure.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/programs/configure.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/programs/configure.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/programs/configure.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/programs/configure.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2017 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>