<?php

class ActionSSDAdapterLink extends UserAction {

    private $selectedPt;
    private $diskNumber;
    private $SN;
    private $model;

    protected function validatePara() {
        //check the http request parameters
    }
    protected function initActionPara() {
        $this->selectedPt = getRequestPara("selectedPt");
        $this->diskNumber = getRequestPara("diskNumber");
        $this->SN = getRequestPara("SN");
        $this->model = getRequestPara("model");
    }

    private function doLink() {
        $this->ApiCmd = new XMLAPICommand();
        $this->ApiCmd->setCommand(XMLAPICommand::MV_SSD_LinkHyper);
        $this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
        $this->ApiCmd->setCommandPara("partition",$this->selectedPt);
        $this->ApiCmd->setCommandPara("disk_number",$this->diskNumber);
        $this->ApiCmd->setCommandPara("model",$this->model);
        $this->ApiCmd->setCommandPara("serial",$this->SN);
        $this->ApiCmd->issueCommand();

        if ($this->ApiCmd->getResult()->RetVal . "") {
            $this->setCmdXmlRetFail();
        }
        else {
            $this->setCmdXmlRetSuccess();
        }
    }

    protected function doAction() {
        $this->doLink();
    }


    private function setCmdXmlRetSuccess() {  //need jump to hyperSSD  TODO
        $this->xmlRet = new SuccessXMLRet();
        $this->xmlRet->Msg = "";
        //$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::LdListPage ;
        $this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName
                ."?Target=" . Target::getHyperSSDDetail . "&HBAID=" . $this->getAdapterID() . "&ID=" . $this->selectedPt;
    }

    private function setCmdXmlRetFail() {
        $this->xmlRet = new FailXMLRet();
        $XMLRoot = $this->ApiCmd->getResult();
        if ($XMLRoot->RetVal . "") {
            $this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getHyperSSDDetail . "&HBAID=" . $this->getAdapterID() . "&ID=" . $this->selectedPt;
            $Err = SSDError::getErrStr(intval($XMLRoot->RetVal));
            $this->xmlRet->Msg = $Err;
        }
    }
}
?>
