<?php
class EnclElement 
{
	private $Type;
	private $ID;
	//private $EnclosureID;
	private $Status;
	
	private $VoltageType;
	private $Voltage;
	private $CurSpeedcode;
	private $CurSpeed;
	private $Temperature;
	private $HCT;  //Temperature High Critical Threshold
	private $HWT;  //Temperature High Warning Threshold
	private $LCT;  //Temperature Low Critical Threshold
	private $LWT;  //Temperature Low Warning Threshold
	
	private $TempWarn;
	private $HotSwap;
	private $DCOverVoltage;
	private $DCUnderVoltage;
	private $DCOverCurrent;
	
	private $OTFailure;
	private $OTWarning;
	private $UTFailure;
	private $UTWarning;
	
	public function setID($ID)
	{
		$this->ID = $ID;
	}
	public function getID()
	{
		return $this->ID;
	}
	
	public function setTempWarn($TempWarn)
	{
		$this->TempWarn = $TempWarn;
	}
	public function getTempWarn()
	{
		return $this->TempWarn;
	}
	
	public function setHotSwap($HotSwap)
	{
		$this->HotSwap = $HotSwap;
	}
	public function getHotSwap()
	{
		return $this->HotSwap;
	}
	
	public function setDCOverVoltage($DCOverVoltage)
	{
		$this->DCOverVoltage = $DCOverVoltage;
	}
	public function getDCOverVoltage()
	{
		return $this->DCOverVoltage;
	}
	
	public function setDCUnderVoltage($DCUnderVoltage)
	{
		$this->DCUnderVoltage = $DCUnderVoltage;
	}
	public function getDCUnderVoltage()
	{
		return $this->DCUnderVoltage;
	}
	
	public function setDCOverCurrent($DCOverCurrent)
	{
		$this->DCOverCurrent = $DCOverCurrent;
	}
	public function getDCOverCurrent()
	{
		return $this->DCOverCurrent;
	}
	
	public function setOTFailure($OTFailure)
	{
		$this->OTFailure = $OTFailure;
	}
	public function getOTFailure()
	{
		return $this->OTFailure;
	}
	
	public function setOTWarning($OTWarning)
	{
		$this->OTWarning = $OTWarning;
	}
	public function getOTWarning()
	{
		return $this->OTWarning;
	}
	
	public function setUTFailure($UTFailure)
	{
		$this->UTFailure = $UTFailure;
	}
	public function getUTFailure()
	{
		return $this->UTFailure;
	}
	
	public function setUTWarning($UTWarning)
	{
		$this->UTWarning = $UTWarning;
	}
	public function getUTWarning()
	{
		return $this->UTWarning;
	}
	
	public function setStatus($Status)
	{
		$this->Status = $Status;
	}
	public function getStatus()
	{
		return $this->Status;
	}
	
	public function setType($Type)
	{
		$this->Type = $Type;
	}
	public function getType()
	{
		return $this->Type;
	}
	
	public function setVoltageType($VoltageType)
	{
		$this->VoltageType = $VoltageType;
	}
	public function getVoltageType()
	{
		return $this->VoltageType;
	}
	
	public function setVoltage($Voltage)
	{
		$this->Voltage = $Voltage;
	}
	public function getVoltage()
	{
		return $this->Voltage;
	}
	
	public function setCurSpeed($CurSpeed)
	{
		$this->CurSpeed = $CurSpeed;
	}
	public function getCurSpeed()
	{
		return $this->CurSpeed;
	}
	
	public function setCurSpeedcode($CurSpeedcode)
	{
		$this->CurSpeedcode = $CurSpeedcode;
	}
	public function getCurSpeedcode()
	{
		return $this->CurSpeedcode;
	}
	
	public function setTemperature($Temperature)
	{
		$this->Temperature = $Temperature;
	}
	public function getTemperature()
	{
		return $this->Temperature;
	}
	
	public function setHCT($HCT)
	{
		$this->HCT = $HCT;
	}
	public function getHCT()
	{
		return $this->HCT;
	}
	
	public function setHWT($HWT)
	{
		$this->HWT = $HWT;
	}
	public function getHWT()
	{
		return $this->HWT;
	}
	
	public function setLCT($LCT)
	{
		$this->LCT = $LCT;
	}
	public function getLCT()
	{
		return $this->LCT;
	}
	
	public function setLWT($LWT)
	{
		$this->LWT = $LWT;
	}
	public function getLWT()
	{
		return $this->LWT;
	}
	
	public function setEnclElementInfo($Info)
	{
		if (isset($Info->ElementID)) {
			$this->setID(trim($Info->ElementID));
		}
		if (isset($Info->Type)) {
			$this->setType(trim($Info->Type));
		}
		if (isset($Info->Status)) {
			$this->setStatus(trim($Info->Status));
		}
		if (isset($Info->TempWarn)) {
			$this->setTempWarn(trim($Info->TempWarn));
		}
		if (isset($Info->HotSwap)) {
			$this->setHotSwap(trim($Info->HotSwap));
		}
		if (isset($Info->DCOverVoltage)) {
			$this->setDCOverVoltage(trim($Info->DCOverVoltage));
		}
		if (isset($Info->DCUnderVoltage)) {
			$this->setDCUnderVoltage(trim($Info->DCUnderVoltage));
		}
		if (isset($Info->DCOverCurrent)) {
			$this->setDCOverCurrent(trim($Info->DCOverCurrent));
		}
		if (isset($Info->OTFailure)) {
			$this->setOTFailure(trim($Info->OTFailure));
		}
		if (isset($Info->OTWarning)) {
			$this->setOTWarning(trim($Info->OTWarning));
		}
		if (isset($Info->UTFailure)) {
			$this->setUTFailure(trim($Info->UTFailure));
		}
		if (isset($Info->UTWarning)) {
			$this->setUTWarning(trim($Info->UTWarning));
		}
		if (isset($Info->VoltageType)) {
			$this->setVoltageType(trim($Info->VoltageType));
		}
		if (isset($Info->Voltage)) {
			$this->setVoltage(trim($Info->Voltage));
		}
		if (isset($Info->CurSpeedcode)) {
			$this->setCurSpeedcode(trim($Info->CurSpeedcode));
		}
		if (isset($Info->CurSpeed)) {
			$this->setCurSpeed(trim($Info->CurSpeed));
		}
		if (isset($Info->Temperature)) {
			$this->setTemperature(trim($Info->Temperature));
		}
	}
	
	public function setEnclElementCfg($Info)
	{
		if (isset($Info->ElementID)) {
			$this->setID(trim($Info->ElementID));
		}
		if (isset($Info->Type)) {
			$this->setType(trim($Info->Type));
		}
		if (isset($Info->Status)) {
			$this->setStatus(trim($Info->Status));
		}
		if (isset($Info->highCriticalThreshold)) {
			$this->setHCT(trim($Info->highCriticalThreshold));
		}
		if (isset($Info->highWarningThreshold)) {
			$this->setHWT(trim($Info->highWarningThreshold));
		}
		if (isset($Info->lowCriticalThreshold)) {
			$this->setLCT(trim($Info->lowCriticalThreshold));
		}
		if (isset($Info->lowWarningThreshold)) {
			$this->setLWT(trim($Info->lowWarningThreshold));
		}
	}
}

?>