<?php
class FreeDiskList extends BaseData 
{
	private $CachePolicy;
	private $HDCount;
	private $HDIDs;

	protected function prepareAPICommands()
	{
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommandPara("AdapterID", $this->AdapterID);
		$XMLApiCmd->setCommand(XMLAPICommand::MV_PD_Get_FreeList);
		
		$this->XMLAPICommandList['setFreeDiskList'] = $XMLApiCmd;
	}

	protected function setFreeDiskList($data)
	{
		$XMLRoot = $data;
		if (isset($XMLRoot->MV_PD_FreeList)) {
			$this->HDIDs = trim($XMLRoot->MV_PD_FreeList->HDIDs);
			$this->HDCount = trim($XMLRoot->MV_PD_FreeList->HDCount);
			$this->CachePolicy = trim($XMLRoot->MV_PD_FreeList->CachePolicy);
		}
	}

	protected function setDataToBaseClass()
	{

	}
	
	public function loadTestData()
	{

	}
	
	public function getPolicy()
	{
		return $this->CachePolicy;
	}
	
	public function getHDCount()
	{
		return $this->HDCount;
	}
	
	public function getHDIDs()
	{
		return $this->HDIDs;
	}
}
?>