<?php
class User
{
	//login info
	public $loginName="";
	public $passwd="";
	public $domain="";
	
	//will be used to identify the user.
	//user id etc..
	public $sessionID="";
	
	//user info
	//email notify user when event of certain type happened.
	public $eventNotify = 0;
	//displayed name
	public $nickName="";
	//mail addr
	public $emailAddr="";
	
	public $userType = UserType::GUEST;
	
	public function setEmailAddr($emailAddr)
	{
		$this->emailAddr = $emailAddr;
	}
	public function getEmailAddr()
	{
		return $this->emailAddr;
	}
	
	public function setLoginName($loginName)
	{
		$this->loginName = $loginName;
	}
	public function getLoginName()
	{
		return $this->loginName;
	}
		
	public function setDomain($domain)
	{
		$this->domain = $domain;
	}
	public function getDomain()
	{
		return $this->domain;
	}
		
	public function setNickName($nickName)
	{
		$this->nickName = $nickName;
	}
	public function getNickName()
	{
		return $this->nickName;
	}

	public function setPasswd($passwd)
	{
		$this->passwd = $passwd;
	}
	public function getPasswd()
	{
		return $this->passwd;
	}

	public function setEventNotify($eventNotify)
	{
		$this->eventNotify = $eventNotify;
	}
	
	public function getEventNotify()
	{
		return $this->eventNotify;
	}
	
	public function isAdmin()
	{
		return intval($this->userType) == UserType::ADMIN;
	}
	
	public function getUserType()
	{
		return $this->userType;
	}
	
	public function setGuest()
	{
		$this->userType = UserType::GUEST;
	}
	
	public function setAdmin()
	{
		$this->userType = UserType::ADMIN;
	}
	
	public function getID()
	{
		return $this->sessionID;
	}
	
	public function setID($ID)
	{
		$this->sessionID = $ID;
	}
	
	public function setInfoFromXML($element)
	{
		$this->loginName = trim($element->loginName);
		$this->domain = trim($element->domain);
		$this->sessionID = trim($element->sessionID);
		$this->eventNotify = trim($element->eventNotify);
		$this->emailAddr = trim($element->emailAddr);
		$this->userType = intval(trim($element->userType));
	}
	
	public static function createUserFromXMLElement($element)
	{
		$user = new User();
		$user->setInfoFromXML($element);
		
		return $user;
	}
}
?>