<?php
abstract class XMLDataAccess implements DataAccess 
{
	protected $eleName;
	protected $parentName;
	protected $fileName;
	
	private $domDoc;
	private $needSave;
	
	protected abstract function dataWrapper($element);
	
	public function __construct($fileName)
	{
		$this->fileName = $fileName;
	}
	
	//in case it is changed by other
	private function loadFile()
	{
		$this->domDoc = new DOMDocument('1.0','UTF-8');
		try {
			if (! file_exists($this->fileName)) {
				$this->restoreFile();
			}
			$ret = $this->domDoc->load($this->fileName);
			if ($ret === false) {
				$this->restoreFile();
				$this->domDoc->load($this->fileName);
			}
		}
		catch (Exception $e){
			$this->restoreFile();
			$this->domDoc->load($this->fileName);
		}
	}
	
	//in case file is changed wrongly
	private function restoreFile()
	{
		$handle = fopen($this->fileName, "w");
		$content =
		'<?xml version="1.0"?>
		<root>
			<Users></Users>
			<BGASchedules></BGASchedules>
			<SystemSetting>
			    <System>
			        <EventReadIndex>0</EventReadIndex>
			    	<userName></userName>
			    	<LastLoginUser>administrator</LastLoginUser>
			        <passwd></passwd>
			        <port>25</port>
					<isSSL>0</isSSL>
			        <serverAddr></serverAddr>
				</System>
			</SystemSetting>
		</root>
		';
		fwrite($handle, $content);
		fclose($handle);
	}
	
	private function saveFile()
	{
		if ($this->needSave) {
			$this->domDoc->save($this->fileName);
		}
	}
	
	public function __destruct()
	{
		unset($this->domDoc);
	}
	
	public function update($dataArray)
	{
		try {
			$this->loadFile();
			$ret = $this->inter_update($dataArray);
			$this->saveFile();
			
			return $ret;
		}
		catch (Exception $e)
		{
		}
	}
	
	
	private function inter_update($dataArray)
	{
		$this->needSave = true;
		
		$eleName = $this->eleName;
				
		$count = 0;
		
		$elements = $this->domDoc->getElementsByTagName($this->eleName);
		$parent = $this->domDoc->getElementsByTagName($this->parentName)->item(0);

		foreach ($elements as $ele)
		{
			$children = $ele->childNodes;
			$found = true;
			$mykeys = $dataArray["mykeys"];
			foreach ($mykeys as $key=>$value)
			{
				$match = false;
				foreach ($children as $child)
				{
					if (trim($child->nodeName) == trim($key) && trim($child->nodeValue) == trim($value)) {
						$match = true;
						break;
					}
				}
				if ($match == false) { //can not found key
					$found = false;
					break;
				}
			}
			if ($found || sizeof($mykeys) == 0) {
				$count++;
				//update values
				$children = $ele->childNodes;
				foreach ($children as $child)
				{
					$values = $dataArray["myvalues"];
					foreach ($values as $key=>$value)
					{
						if ($child->nodeName == trim($key)) {
							//need to check & symbol here.
							$child->nodeValue = htmlspecialchars(trim($value),ENT_QUOTES);
						}
					}
				}
			}
		}
		
		return $count;
	}
	
	public function insert($dataArray)
	{
		try {
			$this->loadFile();
			$ret = $this->inter_insert($dataArray);
			$this->saveFile();
			return $ret;
		}
		catch (Exception $e)
		{
		}
	}
	
	private function inter_insert($dataArray)
	{
		$this->needSave = true;
		
		$eleName = $this->eleName;
		
		$values = $dataArray["myvalues"];
		
		$eles = $this->domDoc->getElementsByTagName($this->parentName);
		
		$element = $this->domDoc->createElement($this->eleName);
		
		foreach ($values as $key => $value)
		{
			//$value = htmlspecialchars($value,ENT_QUOTES);
			$subelement = $this->domDoc->createElement($key);
			$subelementText = $this->domDoc->createTextNode($value);
			$subelement->appendChild($subelementText);
			$element->appendChild($subelement);
		}
		
		if ($eles->item(0)) {
			$eles->item(0)->appendChild($element);
		}
		
		return true;
	}
	
	public function query($dataArray)
	{
		try {
			$this->loadFile();
			return $this->inter_query($dataArray);
		}
		catch (Exception $e)
		{
			
		}
	}
	
	private function inter_query($dataArray)
	{
		$eleName = $this->eleName;
		
		$mykeys = $dataArray["mykeys"];
		
		$result = array();
		
		$elements = $this->domDoc->getElementsByTagName($this->eleName);

		foreach ($elements as $ele)
		{
			$children = $ele->childNodes;
			$found = true;
			foreach ($mykeys as $key=>$value)
			{
				$match = false;
				foreach ($children as $child)
				{
					if (!strcasecmp($child->nodeName, trim($key)) 
						&& !strcasecmp(trim($child->nodeValue), trim($value))) {
						$match = true;
						break;
					}
				}
				if ($match == false) { //can not found key
					$found = false;
					break;
				}
			}
			if ($found || sizeof($mykeys) == 0) {
				$xmlNode = simplexml_import_dom($ele);
				$result[] = $this->dataWrapper($xmlNode);
			}
		}
		
		return $result;
	}
	
	public function delete($dataArray)
	{
		try {
			$this->loadFile();
			$ret = $this->inter_delete($dataArray);
			$this->saveFile();
			return $ret;
		}
		catch (Exception $e)
		{
		}
	}
	
	private function inter_delete($dataArray)
	{
		$this->needSave = true;
		
		$eleName = $this->eleName;
		
		$mykeys = $dataArray["mykeys"];
		
		$count = 0;
		
		$elements = $this->domDoc->getElementsByTagName($this->eleName);
		$parent = $this->domDoc->getElementsByTagName($this->parentName)->item(0);

		$removeArr = array();
		foreach ($elements as $ele)
		{
			$children = $ele->childNodes;
			$found = true;
			
			foreach ($mykeys as $key=>$value)
			{
				$match = false;
				foreach ($children as $child)
				{
					if (trim($child->nodeName) == trim($key) && trim($child->nodeValue) == trim($value)) {
						$match = true;
						break;
					}
				}
				if ($match == false) { //can not found key
					$found = false;
					break;
				}
			}
			
			if ($found || sizeof($mykeys) == 0) {
				$removeArr[] = $ele;
				//$parent->removeChild($ele);
				$count++;
			}
		}
		
		foreach ($removeArr as $removeEle)
		{
			$parent->removeChild($removeEle);
		}
		return $count;
	}
}
?>