<?php

class BBUInfo
{
	public $status;
	public $statusStr;
	public $featureSupport;
	public $supportTemperature;
	public $supportVoltage;
	public $supportEcapacity;
	public $temperature;
	public $voltage;
	public $supportMaxCapacity;
	public $supportMinCapacity;
	public $maxCapacity;
	public $curCapacity;
	public $time_to_empty;
	public $time_to_full;
	public $percentage;
	public $ID;
	public $prev_status;
	public $recharge_cycle;
	public $percent_to_charge;
	public $volt_lowerbound;
	public $volt_upperbound;
	public $temp_lowerbound;
	public $temp_upperbound;
	
	public function setBBUInfo($bbu)
	{
		$this->status = $bbu->getStatus();
		$this->time_to_full = $bbu->getTimeToFull();
		$this->time_to_empty = $bbu->getTimeToEmpty();
		$TmpStr = BBUStatus::getBBUStatusStr($this->status, $this->time_to_full,$this->time_to_empty);
		$this->statusStr = gettext($TmpStr);
		$this->featureSupport = $bbu->getFeatureSupport();
		$this->supportTemperature = $bbu->supportTemperature();
		$this->supportVoltage = $bbu->supportVoltage();
		$this->supportEcapacity = $bbu->supportEcapacity();
		$this->temperature = floatval($bbu->getTemperature())/100;
		$this->voltage = floatval($bbu->getVoltage())/1000;
		$this->supportMaxCapacity = $bbu->getSupportMaxCapacity();
		$this->supportMinCapacity = $bbu->getSupportMinCapacity();
		$this->maxCapacity = floatval($bbu->getMaxCapacity())/100;
		$this->curCapacity = floatval($bbu->getCurCapacity())/100;
		$this->percentage = $bbu->getPercentage();
		$this->ID = $bbu->getID();
		$this->prev_status = $bbu->getPrev_status();
		$this->recharge_cycle = $bbu->getRecharge_cycle();
		$this->percent_to_charge = $bbu->getPercent_to_charge();
		$this->temp_lowerbound = $bbu->getTemp_lowerbound();
		$this->temp_upperbound = $bbu->getTemp_upperbound();
		$this->volt_lowerbound = $bbu->getVolt_lowerbound();
		$this->volt_upperbound = $bbu->getVolt_upperbound();

	}
}

?>