<?php
class ActionRebuildDG extends UserAction 
{
	private $DG_ID = 0;
	private $Rebuild_Type=2;//rebuild dg: 2,rebuild vd: 1
	private $Rebuild_HDCount=0;
	private $Rebuild_HD_ID;
    const ToStopMP = "ToStopMP";
    protected $isRunningMP = 0;
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->DG_ID = getRequestPara("DGID");
	//	$this->Rebuild_Type = getRequestPara("RebuildType");
	//	$this->Rebuild_HDCount = getRequestPara("HDCount");
		$this->Rebuild_HD_ID = getRequestPara("HDID");
	}
	
	private function doRebuild()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_LD_DG_StartRebuild);
		$this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
		$this->ApiCmd->setCommandPara("ID",$this->DG_ID);
		$this->ApiCmd->setCommandPara("RebuildType",$this->Rebuild_Type);
		
		//Rebuild_HDCount
		$hds = explode(" ",$this->Rebuild_HD_ID);
		foreach ($hds as $Hd)
		{
			if (trim($Hd) != "") {
				$this->Rebuild_HDCount ++;
			}
		}
		$this->ApiCmd->setCommandPara("PDCount",$this->Rebuild_HDCount);
		$this->ApiCmd->setCommandPara("PDIDs",$this->Rebuild_HD_ID);
		
		$this->ApiCmd->issueCommand();
		
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setDGCmdXmlRetFail();
		}
		else {
			$this->setDGCmdXmlRetSuccess();
		}
	}

	private function setFlags()
	{
		include_once("../phpsrc/baseclass/Device.class.php");
		include_once("../phpsrc/baseclass/SASDevice.class.php");
		include_once("../phpsrc/baseclass/DeviceFactory.class.php");
		include_once("../phpsrc/baseclass/PortDevice.class.php");
		include_once("../phpsrc/baseclass/Block.class.php");
		include_once("../phpsrc/baseclass/HD.class.php");
		include_once("../phpsrc/baseclass/PM.class.php");
		include_once("../phpsrc/baseclass/HBA.class.php");
		include_once("../phpsrc/baseclass/ExpanderDevice.class.php");
		include_once("../phpsrc/baseclass/DG.class.php");
		include_once("../phpsrc/baseclass/DgDetail.class.php");
		$dgDtl = new DgDetail();
		$dgDtl->setAdapterID($this->getAdapterID());
		$dgDtl->setDGID($this->DG_ID);
		$dgDtl->toGetDgInfo();

		$base = $dgDtl->getBaseClasses();
		if (sizeof($base)) {
		    $dgDetail = array_shift($base);
            if ($dgDetail->getPDBgaRunning()) {
                $this->isRunningMP = 1;
            }
        }
    }
	protected function doAction()
	{
        $cmdName = trim(getRequestPara("cmdName"));
		$this->setFlags();
        if ((getRequestPara(self::ToStopMP) == null) && $this->isRunningMP) {
			$YesUrl = getBaseURL() . PHPPageName::CmdPageName
				. "?cmdName=" . $cmdName ;
			$YesUrl .=  "&DGID" . "=" . $this->DG_ID . "&HDID" . "=" . $this->Rebuild_HD_ID
                        . "&HBAID=" . $this->HBAID;
			$YesUrl .=  "&" . self::ToStopMP  . "= 1";

			$NoUrl = getBaseURL()
					. PHPPageName::TargetPageName ."?Target=" . Target::getArraySubPage
                    . "&ID=" . $this->DG_ID . "&HBAID=" . $this->HBAID;

			$this->xmlRet = new ContXMLRet();
			$this->xmlRet->Msg =
				AlertMsg::DGREBUILD_STOP_MP;
			$this->xmlRet->YesUrl = $YesUrl;
			$this->xmlRet->NoUrl = $NoUrl;
			$this->xmlRet->YesUrlType = XMLRetUrlType::CmdUrl;
			$this->xmlRet->NoUrlType = XMLRetUrlType::PageUrl;
            return;
        }

		$this->doRebuild();
	}
}
?>