<?php
class ActionRebuildPackageVD extends UserAction
{
	private $LD_ID = 0;
	private $Rebuild_Type=2;//rebuild dg: 2,rebuild vd: 1
	private $Rebuild_HDCount=0;
	private $Rebuild_HD_ID;
    const ToStopMP = "ToStopMP";
    protected $isRunningMP = 0;

	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->LD_ID = getRequestPara("LDID");
		$this->Rebuild_HD_ID = getRequestPara("HDID");
	}

	private function doRebuild()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_Package_VD_StartRebuild);
		$this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
		$this->ApiCmd->setCommandPara("ID",$this->LD_ID);
		$this->ApiCmd->setCommandPara("RebuildType",$this->Rebuild_Type);

		//Rebuild_HDCount
		$hds = explode(" ",$this->Rebuild_HD_ID);
		foreach ($hds as $Hd)
		{
			if (trim($Hd) != "") {
				$this->Rebuild_HDCount ++;
			}
		}
		$this->ApiCmd->setCommandPara("PDCount",$this->Rebuild_HDCount);
		$this->ApiCmd->setCommandPara("PDIDs",$this->Rebuild_HD_ID);

		$this->ApiCmd->issueCommand();

		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setPackageVDCmdXmlRetFail();
		}
		else {
			$this->setPackageVDCmdXmlRetSuccess();
		}
	}

	private function setFlags()
	{
		include_once("../phpsrc/baseclass/Device.class.php");
		include_once("../phpsrc/baseclass/SASDevice.class.php");
		include_once("../phpsrc/baseclass/DeviceFactory.class.php");
		include_once("../phpsrc/baseclass/PortDevice.class.php");
		include_once("../phpsrc/baseclass/Block.class.php");
		include_once("../phpsrc/baseclass/HD.class.php");
		include_once("../phpsrc/baseclass/PM.class.php");
		include_once("../phpsrc/baseclass/HBA.class.php");
		include_once("../phpsrc/baseclass/ExpanderDevice.class.php");
		include_once("../phpsrc/baseclass/PackageVD.class.php");
		include_once("../phpsrc/baseclass/PackageVDDetail.class.php");
		$ldDetail = new PackageVDDetail();
		$ldDetail->setAdapterID($this->getAdapterID());
		$ldDetail->setID($this->DG_ID);
		$ldDetail->toGetLDInfo();

		$ld = $ldDetail->getBaseDetail();

        if ($ld->getPDBgaRunning()) {
            $this->isRunningMP = 1;
        }
    }

	protected function doAction()
	{
        $cmdName = trim(getRequestPara("cmdName"));
		$this->setFlags();
        if ((getRequestPara(self::ToStopMP) == null) && $this->isRunningMP) {
			$YesUrl = getBaseURL() . PHPPageName::CmdPageName
				. "?cmdName=" . $cmdName ;
			$YesUrl .=  "&LDID" . "=" . $this->LD_ID . "&HDID" . "=" . $this->Rebuild_HD_ID
                        . "&HBAID=" . $this->HBAID;
			$YesUrl .=  "&" . self::ToStopMP  . "= 1";

			$NoUrl = getBaseURL()
					. PHPPageName::TargetPageName ."?Target=" . Target::getPackageVDPage
                    . "&ID=" . $this->LD_ID . "&HBAID=" . $this->HBAID;

			$this->xmlRet = new ContXMLRet();
			$this->xmlRet->Msg =
				AlertMsg::LDREBUILD_STOP_MP;
			$this->xmlRet->YesUrl = $YesUrl;
			$this->xmlRet->NoUrl = $NoUrl;
			$this->xmlRet->YesUrlType = XMLRetUrlType::CmdUrl;
			$this->xmlRet->NoUrlType = XMLRetUrlType::PageUrl;
            return;
        }

		$this->doRebuild();
	}
}
?>