<?php
class RCT
{
	public $LBAAddr=0;
	public $sectorCount=0;
	public $flagString="";
	
	public function setRCT($rctRecord)
	{
		$this->LBAAddr = sprintf("0x%04x", $rctRecord->getLBA());
		$this->sectorCount = intval($rctRecord->getSec());
		
		$flag = $rctRecord->getFlag();
		
		if($flag & RCTFlag::EH_READ_VERIFY_REQ_ERROR)
		{
			$this->flagString .= gettext(RCTFlag::STR_EH_READ_VERIFY_REQ_ERROR);
		}
		
		if($flag & RCTFlag::EH_WRITE_REQ_ERROR )
		{
			if($this->flagString)
			{
				$this->flagString .= "," . gettext(RCTFlag::STR_EH_WRITE_REQ_ERROR);
			}
			else
			{
				$this->flagString .= gettext(RCTFlag::STR_EH_WRITE_REQ_ERROR);
			}
		}
		
		if($flag & RCTFlag::EH_MEDIA_ERROR)
		{
			if($this->flagString)
			{
				$this->flagString .= "," . gettext(RCTFlag::STR_EH_MEDIA_ERROR);
			}
			else
			{
				$this->flagString .= gettext(RCTFlag::STR_EH_MEDIA_ERROR);
			}
		}
		
		if($flag & RCTFlag::EH_LOGICAL_ERROR)
		{
			if($this->flagString)
			{
				$this->flagString .= "," . gettext(RCTFlag::STR_EH_LOGICAL_ERROR);
			}
			else
			{
				$this->flagString .= gettext(RCTFlag::STR_EH_LOGICAL_ERROR);
			}
		}
	}
	
	public function convertWords()
	{
		
	}
}

class CtnRCTRecordList
{
	const RCT_MAX_NUM = 100; //the XML doc buffer of zraidapi can contain 100 Record xml Elements 
	
	private $allRCTs = array();
	private $startNo = 0;
	private $HD_ID = 0;
	private $AdapterID = GET_ALL;
	
	public function setAdapterID($hbaId)
	{
		$this->AdapterID = $hbaId;
	}
	
	public function getAdapterID()
	{
		return $this->AdapterID;
	}
	
	public function getRCTs()
	{
		return $this->allRCTs;
	}
	
	public function setStartNo($startNo)
	{
		$this->startNo = $startNo;
	}
	
	public function setHDID($HD_ID)
	{
		$this->HD_ID = $HD_ID;
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
	
	protected function initBases()
	{
		$rctMaxNum = RCTRecordList::GetMaxRecordNum($this->AdapterID, $this->HD_ID);
		
		$this->base = array();
		
		for ($i = $this->startNo; $i < $rctMaxNum; $i = $i + self::RCT_MAX_NUM)
		{
			$rctList = new RCTRecordList();
			$rctList->setStartNo($i);
			$rctList->setRecordMaxNum($rctMaxNum);
			$rctList->setAdapterID($this->getAdapterID());
			$rctList->setHDID($this->HD_ID);
			if ($i + self::RCT_MAX_NUM > $rctMaxNum) 
			{
				$rctList->setRecordNum($rctMaxNum - $i);
			}
			else 
			{
				$rctList->setRecordNum(self::RCT_MAX_NUM);
			}
			
			$this->base[] = $rctList;
		}
	}
	
	private function setDataFromBase()
	{
		$this->allRCTs = array();
		foreach ($this->base as $rctRecordList)
		{
			$rcts = array();
			$bases = $rctRecordList->getBaseClasses();
			foreach ($bases as $rctRecord)
			{
				$rct = new RCT();
				$rct->setRCT($rctRecord);
				$rct->convertWords();
				
				$rcts[] = $rct;
			}
			$this->allRCTs = array_merge($this->allRCTs,$rcts);
		}
		//$this->allRCTs = array_reverse($this->allRCTs);
	}
	
	protected function saveDataToPage()
	{
		$this->smarty->assign("RCTList",$this->allRCTs);
		$this->smarty->assign("TotalCount",sizeof($this->allRCTs));
	}
	
	public function initData()
	{
		$this->initBases();
		foreach ($this->base as $rctList)
		{
			$rctList->initData();
		}
		$this->setDataFromBase();
	}
		
	//over ride the base class' initContainer() method
	public function initContainer()
	{
		$this->initBases();
		foreach ($this->base as $rctList)
		{
			$rctList->initData();
		}
		$this->setDataFromBase();
		$this->saveDataToPage();
	}
	
	protected function displayXML()
	{
		//$this->display("EventsSaveFilePage.tpl");
	}
}
?>