<?php
//include_once("PageDisplayer.class.php");

class PgRebuildDgDisplayer extends PgRebuildDisplayer
{
	
	protected function setDisplayInfo()
	{
		parent::setDisplayInfo();
		$this->smarty->assign("isDGBGA",1);
		$this->smarty->assign("ScheduledBgaType",ScheduledBGAType::DG_BGA_REBUILD);
	}
	
	protected function setInfo()
	{
		$ID = getRequestPara('ID');
		$HBAID = $this->getAdapterID();
		if ($ID == null) {
			$this->displayDefaultPage(Target::getSystemSubPage);
			return;
		}
		
		$smarty = $this->smarty;
		
		//add for sub menu
		$container = new CtnDgDetail();
		$container->setAdapterID($HBAID);		
		$container->setDGID($ID);		
		$container->toGetDgInfo();
		$container->toGetDGConfig();
		$container->toGetDgLDInfo();
		$container->toGetDgHDInfo();
		$container->smartyAssign($smarty);
		$container->initContainer();
		
		$dglst = $container->getBase()->getBaseClasses();
		if (!sizeof($dglst)) {
			$Name = gettext('DG Not Exist');
			$smarty->assign('DGNotExist',1);
		}
		else {
			$dgDetail = array_shift($dglst);
			$Name = $dgDetail->getName();
			//$adpID = $dgDetail->getAdapterID();
			
			//$this->setHBAID($adpID);
			
			$HDs = $dgDetail->getHDList();
			if($HDs)
			{
				$filter = new HdRebuildForDgFilter($dgDetail->getSmallestAvailablePDSize(),$HDs,$ID);
			
				$hdList = new CtnHdList();
				$hdList->setAdapterID($HBAID);
				$hdList->toGetHDInfo();
				$hdList->toGetValidSize();
				$hdList->toGetSpareInfo();
				$hdList->toGetHdFreeInfo();
				$hdList->setFilter($filter);
				$hdList->smartyAssign($smarty);
				$hdList->initContainer();
			}
			
		}
		
    	$CancelAlert = gettext(AlertMsg::REBUILD_CANCEL)."?";
    	$smarty->assign("CancelAlert",$CancelAlert);
    	$smarty->assign("ID",$ID);
    	$smarty->assign("HBAID",$HBAID);
    	$smarty->assign("Name",$Name);

	}
}
?>