<?php
class ActionSSDAdapterCreate extends UserAction {

    private $HDCount;
    private $HDIDs;
    private $AcceleratorSizes;
    private $HyperID;
    //private $HBAID;
    private $startLBA;

    protected function validatePara() {}

    protected function initActionPara() {
        $this->HDCount = getRequestPara("HDCount");
        //$this->HBAID = $this->getAdapterID();
        $this->HDIDs = getRequestPara("HDIDs");
        $this->AcceleratorSizes = getRequestPara("AccSizes");
        $this->startLBA = getRequestPara("startLBA");
    }

    private function getExistedHyperSSDs() {
        $oldHypers = new HyperSSDList();
        $oldHypers->setAdapterID($this->getAdapterID());
        $oldHypers->toGetSystemDiskForHyperSSD();

        $oldHyperIDs = array();
        foreach ($oldHypers->getBaseClasses() as $hyper) {
            $oldHyperIDs[] = $hyper->get_id();
        }
        return $oldHyperIDs;
    }

    private function getHypersAfterCreate() {
        $newHypers = new HyperSSDList();
        $newHypers->setAdapterID($this->getAdapterID());
        $newHypers->toGetSystemDiskForHyperSSD();

        $newHyperIDs = array();
        foreach ($newHypers->getBaseClasses() as $hyper) {
            $newHyperIDs[] = $hyper->get_id();
        }
        return $newHyperIDs;
    }

    private function doCreate() {
        include_once("../phpsrc/baseclass/HyperSSD.class.php");
        include_once("../phpsrc/baseclass/HyperSSDList.class.php");
        $oldHyperIDs = $this->getExistedHyperSSDs();

        $this->ApiCmd = new XMLAPICommand();
        $this->ApiCmd->setCommand(XMLAPICommand::MV_SSD_CreateHyperSSD);
        $this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
        $this->ApiCmd->setCommandPara("startLBA",$this->startLBA);
        $this->ApiCmd->setCommandPara("diskNums",$this->HDIDs);

        $sizeArr = explode(" ", $this->AcceleratorSizes);
        $sizes = "";
        foreach ($sizeArr as $size) {
           if (trim($size) != "")
               $sizes .= $size * UNIT_KILO . " ";
        }
        
        $this->ApiCmd->setCommandPara("sizes",trim($sizes));//use M

        $this->ApiCmd->setCommandPara("diskCount",$this->HDCount);
        //var_dump($this->ApiCmd);
        $this->ApiCmd->issueCommand();

        if (!$this->ApiCmd->getResult() ||$this->ApiCmd->getResult()->RetVal . "") {
            $this->setCreateFail();
        } else {
            $newHyperIDs = $this->getHypersAfterCreate();

            $arr = array_diff($newHyperIDs, $oldHyperIDs);
            if ($arr) {
                $this->HyperID = array_shift($arr);
            }

            $this->setCreateCmdXmlRetSuccess();
        }
    }

    private function setCreateCmdXmlRetSuccess() {
        $this->xmlRet = new SuccessXMLRet();
        $this->xmlRet->Msg = "";
        //$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::LdListPage ;
        $this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName
                ."?Target=" . Target::getHyperSSDDetail . "&ID=" . $this->HyperID . "&HBAID=" . $this->getAdapterID();
    }

    private function setCreateFail() {
        $this->xmlRet = new FailXMLRet();
        $XMLRoot = $this->ApiCmd->getResult();
        if ($XMLRoot->RetVal . "") {
            $this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getSSDAdapterDetail . "&ID=" . $this->getAdapterID() ;
            $Err = ComError::getErrStr(intval($XMLRoot->RetVal));
            $this->xmlRet->Msg = $Err;
        }
    }
    protected function doAction() {
        $this->doCreate();
    }
}
?>
