<?php
abstract class EnclBase extends BaseFactory 
{
	const UNDEFINED_ID = 0xFFFF; 
	public function toGetEnclExpanderInfo()
	{
		$expList = new ExpanderList();
		$expList->setAdapterID($this->getAdapterID());
		$expList->toGetExpInfo();
		foreach ($expList->getBaseClasses() as $exp)
		{
			//if there is no enclosure ID related
			if ($exp->getEnclosureID() == UNDEFINED_ID) 
			{
				$this->addExpanderToAirEnc($exp);
			}
			else
			{
				foreach ($this->BaseClasses as $enc)
				{
					if ($exp->getEnclosureID() == $enc->getDeviceID()) {
						$enc->addExpander($exp);
						break;
					}
				}
				
				// Add to Expander List too.
				//$this->addExpanderToAirEnc($exp);
			}
		}
	}
	
	public function toGetEnclPMInfo()
	{
		//
		$pmList = new PMList();
		$pmList->setAdapterID($this->getAdapterID());
		$pmList->toGetPMInfo();
		foreach ($pmList->getBaseClasses() as $pm)
		{
			//
			if ($pm->getEnclosureID() == UNDEFINED_ID)  {
				$this->addPMToAirEnc($pm);
			}
			else{
				foreach ($this->BaseClasses as $enc)
				{
					if ($pm->getEnclosureID() == $enc->getDeviceID()) {
						$enc->addPM($pm);
						break;
					}
				}
				
				// Add to Expander List too.
				//$this->addPMToAirEnc($pm);
			}
		}
	}
	
	public function toGetEnclInfo()
	{
		//
		$handler = new EncInfoXmlHandler();
		$this->runCommand(XMLAPICommand::MV_ENC_GetEnclosureInfo, $handler);
	}
	
	public function addExpanderToAirEnc($exp)
	{
		$Air_Encl = null;
		$notfound = true;
		foreach ($this->BaseClasses as $enc)
		{
			if ($enc->getDeviceID() == UNDEFINED_ID) {
				$Air_Encl = $enc;				
				$notfound = false;
				break;
			}
		}
		
		if ($notfound) {
			$Air_Encl = $this->addAirEnc();
		}
		
		$Air_Encl->addExpander($exp);
	}
	
	public function addAirEnc()
	{
		$Air_Encl = new Encl();
		$Port = new PortDevice();
		$Air_Encl->setParentDevice($Port);			
		$Air_Encl->setStatus(ENCStatus::STATUS_NOT_EXIST);
		$Air_Encl->setVendorId("N/A");
		$Air_Encl->setProductId("N/A");
		$Air_Encl->setProductRevision("N/A");
		$Air_Encl->setDeviceID(self::UNDEFINED_ID);
		$Air_Encl->setAdapterID($this->getAdapterID());
		
		$this->BaseClasses[$Air_Encl->getDeviceID()] = $Air_Encl;
		
		return $Air_Encl;
	}
	
	public function addPMToAirEnc($pm)
	{
		$Air_Encl = null;
		$notfound = true;
		foreach ($this->BaseClasses as $enc)
		{
			if ($enc->getDeviceID() == UNDEFINED_ID) {
				$Air_Encl = $enc;				
				$notfound = false;
				break;
			}
		}
		
		if ($notfound) {
			$Air_Encl = $this->addAirEnc();
		}
		
		$Air_Encl->addPM($pm);
	}
	
	protected function createObject()
	{
		return new Encl();
	}
}

?>