<?php

abstract class PartitionXmlHandler extends XmlHandler {

}

class PartitionInfoXmlHandler extends PartitionXmlHandler {
    public function handle($XMLRoot) {
        $factory = $this->getFactory();

        if (isset($XMLRoot->partition_information)) {
            foreach($XMLRoot->partition_information as $info) {
                $id = intval($info->id);
                if ($factory->hasObj($id)) {
                    $partition = $factory->getObj($id);
                    $partition->setPartitionInfo($info);
                }
                else {
                    $partition = $this->getFactory()->createObj($id);
                    $partition->setPartitionInfo($info);
                }
            }
        }
    }
}

class PartitionLinkXmlHandler extends PartitionXmlHandler {
    public function handle($XMLRoot) {
        $factory = $this->getFactory();
        if (isset($XMLRoot->partition_link_t)) {
            foreach($XMLRoot->partition_link_t as $linkList) {
                    $link = $linkList->partition_information;
                    $disk = $linkList->disk_info_t;
                    
                    $id = intval($link->id);
                    if ($factory->hasObj($id)) {
                        $partition = $factory->getObj($id);
                        $partition->setPartitionLink($link);
                        $partition->setDiskInfo($disk);
                    }
                    else {
                        $partition = $this->getFactory()->createObj($id);
                        $partition->setPartitionLink($link);
                        $partition->setDiskInfo($disk);
                    }
                
            }
        }
    }
}


?>
