<?php
class LD
{
	private $ID = 0;
 	private $Status = 0;
 	private $BGAStatus = 0;
 	private $StripeBlockSize = 0;
 	private $Raid_Level = 0;
 	private $HDCount=0;
 	//private $CacheMode;
 	private $AutoRebuildOn;
 	private $WriteCache=0;
 	private $WriteCacheStatus=0;
 	private $ReadCache=0;
 	private $Size=0;
 	private $SectorSize = 0;
 	private $Name=0;
 	private $BlockList = array();
 	private $BlockIDList = array();
 	private $ConflictVDsList = array();
 	//private $SubLDCount; 	
 	
 	
 	//private $Status;
	private $Bga = 0;
	private $BgaPercentage = 0;
	private $BgaState = 0;
    private $BgaExt = 0;

	private $AdapterID;
	private $LastWriteTime;
	private $HypperWaterMark;

    private $VD_status;
	
	public function __construct()
	{
		$this->BlockList = array();
	}
	
	public function getHypperWaterMark()
	{
		return $this->HypperWaterMark;
	}
	
	public function getLastWriteTime()
	{
		return $this->LastWriteTime;
	}
	public function getConflictVDsList()
	{
		return $this->ConflictVDsList;
	}
	public function getAdapterID()
	{
		return $this->AdapterID;
	}
	public function setAdapterID($AdapterID)
	{
		$this->AdapterID = $AdapterID;
	}
	
	public function setStatus($Status)
	{
		$this->Status = $Status;
	}
	public function getStatus()
	{
		return $this->Status;
	}
	
	public function setAutoRebuildOn()
	{
		$this->AutoRebuildOn = 1;
	}
	public function setAutoRebuildOff()
	{
		$this->AutoRebuildOn = 0;
	}
	
	public function isAutoRebuildOn()
	{
		return $this->AutoRebuildOn;
	}
	
	public function setBGAStatus($BGAStatus)
	{
		$this->BGAStatus = $BGAStatus;
	}
	public function getBGAStatus()
	{
		return $this->BGAStatus;
	}
	
	public function setStripeBlockSize($StripeBlockSize)
	{
		$this->StripeBlockSize = $StripeBlockSize;
	}
	public function getStripeBlockSize()
	{
		return $this->StripeBlockSize;
	}
	
	public function setRaid_Level($Raid_Level)
	{
		$this->Raid_Level = $Raid_Level;
	}
	public function getRaid_Level()
	{
		return $this->Raid_Level;
	}
	
	
	public function setHDCount($HDCount)
	{
		$this->HDCount = $HDCount;
	}
	public function getHDCount()
	{
		return $this->HDCount;
	}
	
	
	public function setWriteCache($WriteCache)
	{
		$this->WriteCache = $WriteCache;
	}
	public function getWriteCache()
	{
		return $this->WriteCache;
	}
	
	public function getWriteCacheStatus()
	{
		return $this->WriteCacheStatus;
	}
	
	public function setReadCache($ReadCache)
	{
		$this->ReadCache = $ReadCache;
	}
	public function getReadCache()
	{
		return $this->ReadCache;
	}
	
	public function setSectorSize($SectorSize)
	{
		$this->SectorSize = $SectorSize;
	}
	public function getSectorSize()
	{
		return $this->SectorSize;
	}
	
	public function setSize($Size)
	{
		$this->Size = $Size;
	}
	public function getSize()
	{
		return $this->Size;
	}
	
	public function setName($Name)
	{
		$this->Name = $Name;
	}
	public function getName()
	{
		return $this->Name;
	}
	
	public function setBlockList($BlockList)
	{
		$this->BlockList = $BlockList;
	}
	public function getBlockList()
	{
		return $this->BlockList;
	}
	
	public function addBlock($blk)
	{
		$this->BlockList[$blk->getID()] = $blk;
		$blk->linkLD($this);
	}
	
	public function hasBlock($id)
	{
		if (isset($this->BlockList[$id])) {
			return true;
		}
		
		return false;
	}
	
	public function setBlockIDList($BlockList)
	{
		$this->BlockIDList = $BlockList;
	}
	public function getBlockIDList()
	{
		return $this->BlockIDList;
	}
	
	/*public function setSubLDCount($SubLDCount)
	{
		$this->SubLDCount = $SubLDCount;
	}
	public function getSubLDCount()
	{
		return $this->SubLDCount;
	}
	*/
	public function setBga($Bga)
	{
		$this->Bga = $Bga;
	}
	public function getBga()
	{
		return $this->Bga;
	}
	
	public function setBgaPercentage($BgaPercentage)
	{
		$this->BgaPercentage = $BgaPercentage;
	}
	public function getBgaPercentage()
	{
		return $this->BgaPercentage;
	}
	
	public function setBgaState($BgaState)
	{
		$this->BgaState = $BgaState;
	}
	public function getBgaState()
	{
		return $this->BgaState;
	}

	public function setBgaExt($BgaExt)
	{
		$this->BgaExt = $BgaExt;
	}
    
	public function getBgaExt()
	{
		return $this->BgaExt;
	}

	public function setID($ID)
	{
		$this->ID = $ID;
	}
	public function getID()
	{
		return $this->ID;
	}
	public function getVD_status()
    {
        return $this->VD_status;
    }
	public function isForeign()
	{
		return ($this->Status == LDStatus::LD_STATUS_FOREIGN);
	}
	
	public function isImportable()
	{
		return ($this->Status == LDStatus::LD_STATUS_IMPORTABLE );
	}
	
	public function isNotImportable()
	{
		return ($this->Status == LDStatus::LD_STATUS_NOT_IMPORTABLE);
	}
	/*
	public function setCacheMode($CacheMode)
	{
		$this->CacheMode = $CacheMode;
	}
	public function getCacheMode()
	{
		return $this->CacheMode;
	}
	
	public function setAutoRebuildOn($AutoRebuildOn)
	{
		$this->AutoRebuildOn = $AutoRebuildOn;
	}
	
	public function getAutoRebuildOn()
	{
		return $this->AutoRebuildOn;
	}
	*/
	
	public function setLdInfo($Info)
	{
		if (isset($Info->ID)) {
 			$this->ID = trim($Info->ID);
 		}
		if (isset($Info->Status)) {
 			$this->Status = trim($Info->Status);
 		}
		if (isset($Info->CacheMode)) {
			$this->WriteCacheStatus = $Info->CacheMode & LDCacheMode::WRITE_POLICY_FILTER;
 		}
 		if (isset($Info->BGAStatus)) {
 			$this->BGAStatus = trim($Info->BGAStatus);
 		}
 		if (isset($Info->StripeBlockSize)) {
 			$this->StripeBlockSize = trim($Info->StripeBlockSize);
 		}
 		if (isset($Info->RaidMode)) {
 			$this->Raid_Level = trim($Info->RaidMode);
 		}
 		if (isset($Info->HDCount)) {
 			$this->HDCount = trim($Info->HDCount);
 		}
 		if (isset($Info->Size)) {
 			$this->Size = floatval(trim($Info->Size));
 		}
 		
 		if (isset($Info->SectorCoefficient)) {
 			$this->SectorSize = intval(trim($Info->SectorCoefficient)) * 512;
 		}
 		
 		if (isset($Info->Name)) {
 			$this->Name = trim($Info->Name);
 		}
 		
 		if (isset($Info->AdapterID)) {
 			$this->AdapterID = trim($Info->AdapterID);
 		}
 		
 		if (isset($Info->BlockIDs)) {
 			$this->BlockIDList = array();
 			$blocks = explode(' ', trim($Info->BlockIDs));
 			foreach ($blocks as $id)
 			{
 				if (trim($id) !== "" && $id != INVALID_ID) {
 					$this->BlockIDList[] = $id;
 				}
 			}
 		}
 		
 		if (isset($Info->ConflictVDs)) {
 			$vds = explode(' ', trim($Info->ConflictVDs));
 			foreach ($vds as $vd)
 			{
 				if (trim($vd) !== "" && $vd != INVALID_ID) {
 					$this->ConflictVDsList[] = $vd;
 				}
 			}
 		}
 		
 		if (isset($Info->LastWriteTime)) {
 			$this->LastWriteTime = $Info->LastWriteTime;
 		}
 		
 		/*
 		if (isset($Info->SubLDCount)) {
 			$this->SubLDCount = trim($Info->SubLDCount);
 		}
 		*/

 		if (isset($Info->VD_status)) {
 			$this->VD_status = $Info->VD_status;
 		}
	}
	
	public function setLdStatus($Status)
	{
		if (isset($Status->LDID)) {
 			$this->ID = trim($Status->LDID);
 		}
		/*if (isset($Status->Status)) {
			$this->Status = trim($Status->Status);
		}*/
		if (isset($Status->Bga)) {
			$this->Bga = (trim($Status->Bga));
		}
		if (isset($Status->BgaPercentage)) {
			$this->BgaPercentage = (trim($Status->BgaPercentage));
		}
		if (isset($Status->BgaState)) {
			$this->BgaState = (trim($Status->BgaState));
		}
		if (isset($Status->BgaExt)) {
			$this->BgaExt = (trim($Status->BgaExt));
		}
	}
	
	public function setLdConfig($Config)
	{
		if (isset($Config->LDID)) {
 			$this->ID = trim($Config->LDID);
 		}
		if (isset($Config->CacheMode)) { //only write cache used, no read cache
			$this->WriteCache = $Config->CacheMode & LDCacheMode::WRITE_POLICY_FILTER;
			$this->ReadCache =  $Config->CacheMode & LDCacheMode::LOOKAHEAD_ENABLE;
		}
		
		if (isset($Config->AutoRebuildOn)) {
			$this->AutoRebuildOn = trim($Config->AutoRebuildOn);
		}
		
//		if (isset($Config->Status)) {
//			$this->Status = trim($Config->Status);
//		}
		if (isset($Config->Name)) {
			$this->Name = trim($Config->Name);
		}
		if (isset($Config->HypperWaterMark)) {
			$this->HypperWaterMark = trim($Config->HypperWaterMark);
		}
	}
	
}

?>